/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.fasterxml.jackson.databind.JsonNode;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.ApplicationRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.ClusterRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.CommandRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import com.netflix.genie.web.apis.rest.v3.controllers.RootRestController;
import com.netflix.genie.web.apis.rest.v3.hateoas.resources.RootResource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;

public class RootResourceAssembler
implements ResourceAssembler<JsonNode, RootResource> {
    private static final String APPLICATIONS_LINK = "applications";
    private static final String COMMANDS_LINK = "commands";
    private static final String CLUSTERS_LINK = "clusters";
    private static final String JOBS_LINK = "jobs";

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS"})
    public RootResource toResource(JsonNode metadata) {
        RootResource rootResource = new RootResource(metadata);
        try {
            rootResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((RootRestController)ControllerLinkBuilder.methodOn(RootRestController.class, (Object[])new Object[0])).getRoot())).withSelfRel());
            rootResource.add(ControllerLinkBuilder.linkTo(((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).createApplication(null)).withRel(APPLICATIONS_LINK));
            rootResource.add(ControllerLinkBuilder.linkTo(((CommandRestController)ControllerLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).createCommand(null)).withRel(COMMANDS_LINK));
            rootResource.add(ControllerLinkBuilder.linkTo(((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).createCluster(null)).withRel(CLUSTERS_LINK));
            rootResource.add(ControllerLinkBuilder.linkTo(((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).submitJob(null, null, null, null)).withRel(JOBS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return rootResource;
    }
}

