/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.aspects;

import com.google.common.collect.Sets;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Aspect
public class HealthCheckMetricsAspect {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckMetricsAspect.class);
    static final String HEALTH_ENDPOINT_TIMER_NAME = "genie.health.endpoint.timer";
    static final String HEALTH_INDICATOR_TIMER_METRIC_NAME = "genie.health.indicator.timer";
    private static final String HEALTH_INDICATOR_COUNTER_METRIC_NAME = "genie.health.indicator.counter";
    private static final String HEALTH_FAILURES_COUNTER_METRIC_NAME = "genie.health.failure.counter";
    private static final String HEALTH_INDICATOR_CLASS_TAG_NAME = "healthIndicatorClass";
    private static final String HEALTH_INDICATOR_NAME_TAG_NAME = "healthIndicatorName";
    private final MeterRegistry registry;

    public HealthCheckMetricsAspect(MeterRegistry registry) {
        this.registry = registry;
    }

    @Around(value="execution(  org.springframework.boot.actuate.health.Health  org.springframework.boot.actuate.health.HealthEndpoint.health())")
    public Health healthEndpointInvokeMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        Health health;
        long start = System.nanoTime();
        Status status = Status.UNKNOWN;
        HashSet tags = Sets.newHashSet();
        try {
            health = (Health)joinPoint.proceed(joinPoint.getArgs());
            status = health.getStatus();
        }
        catch (Throwable t) {
            tags.add(Tag.of((String)"exceptionClass", (String)t.getClass().getCanonicalName()));
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            tags.add(Tag.of((String)"status", (String)status.toString()));
            log.debug("HealthEndpoint.invoke() completed in {} ns", (Object)turnaround);
            this.registry.timer(HEALTH_ENDPOINT_TIMER_NAME, (Iterable)tags).record(turnaround, TimeUnit.NANOSECONDS);
        }
        return health;
    }

    @Around(value="execution(  org.springframework.boot.actuate.health.Health  org.springframework.boot.actuate.health.HealthIndicator.health())")
    public Health healthIndicatorHealthMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        Health h;
        long start = System.nanoTime();
        Throwable throwable = null;
        try {
            h = (Health)joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            this.recordHealthIndicatorTurnaround(turnaround, joinPoint, throwable);
        }
        return h;
    }

    @Around(value="execution(  void org.springframework.boot.actuate.health.AbstractHealthIndicator.doHealthCheck(      org.springframework.boot.actuate.health.Health.Builder  ))")
    public void abstractHealthIndicatorDoHealthCheckMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.nanoTime();
        Throwable throwable = null;
        try {
            joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            this.recordHealthIndicatorTurnaround(turnaround, joinPoint, throwable);
        }
    }

    private void recordHealthIndicatorTurnaround(long turnaround, ProceedingJoinPoint joinPoint, @Nullable Throwable throwable) {
        log.debug("{} completed in {} ns (exception: {})", new Object[]{joinPoint.getTarget().getClass().getSimpleName(), turnaround, throwable != null ? throwable.getClass().getSimpleName() : "none"});
        Set<Tag> tags = throwable == null ? MetricsUtils.newSuccessTagsSet() : MetricsUtils.newFailureTagsSetForException(throwable);
        tags.add(Tag.of((String)HEALTH_INDICATOR_CLASS_TAG_NAME, (String)joinPoint.getTarget().getClass().getSimpleName()));
        this.registry.timer(HEALTH_INDICATOR_TIMER_METRIC_NAME, tags).record(turnaround, TimeUnit.NANOSECONDS);
    }

    @Before(value="execution(  java.util.Map<String, Object>   org.springframework.boot.actuate.health.AbstractHealthAggregator.aggregateDetails(    java.util.Map<String, org.springframework.boot.actuate.health.Health>  ))")
    public void abstractHealthAggregatorAggregateDetailsMonitor(JoinPoint joinPoint) {
        Map healthDetailsMap;
        try {
            Map map;
            healthDetailsMap = map = (Map)joinPoint.getArgs()[0];
        }
        catch (Throwable t) {
            log.warn("Failed to cast AbstractHealthAggregator health details argument: {}", (Object)joinPoint.getArgs(), (Object)t);
            return;
        }
        healthDetailsMap.forEach((name, health) -> {
            HashSet tags = Sets.newHashSet();
            tags.add(Tag.of((String)HEALTH_INDICATOR_NAME_TAG_NAME, (String)name));
            tags.add(Tag.of((String)"status", (String)health.getStatus().getCode()));
            boolean isUp = Status.UP.equals((Object)health.getStatus());
            this.registry.counter(HEALTH_INDICATOR_COUNTER_METRIC_NAME, (Iterable)tags).increment();
            this.registry.counter(HEALTH_FAILURES_COUNTER_METRIC_NAME, (Iterable)tags).increment(isUp ? 0.0 : 1.0);
        });
    }
}

