/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.entities.listeners;

import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.web.data.entities.JobEntity;
import com.netflix.genie.web.data.observers.PersistedJobStatusObserver;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntityListener {
    private static final Logger log = LoggerFactory.getLogger(JobEntityListener.class);
    private final PersistedJobStatusObserver persistedJobStatusObserver;

    public JobEntityListener(PersistedJobStatusObserver persistedJobStatusObserver) {
        this.persistedJobStatusObserver = persistedJobStatusObserver;
    }

    @PostUpdate
    public void jobUpdate(JobEntity jobEntity) {
        JobStatus currentState = jobEntity.getStatus();
        JobStatus previouslyNotifiedState = jobEntity.getNotifiedJobStatus();
        String jobId = jobEntity.getUniqueId();
        if (currentState != previouslyNotifiedState) {
            log.info("Detected state change for job: {} from: {} to: {}", new Object[]{jobId, previouslyNotifiedState, currentState});
            this.persistedJobStatusObserver.notify(jobId, previouslyNotifiedState, currentState);
            jobEntity.setNotifiedJobStatus(currentState);
        }
    }

    @PostLoad
    public void jobLoad(JobEntity jobEntity) {
        jobEntity.setNotifiedJobStatus(jobEntity.getStatus());
    }
}

