/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.repositories.jpa.specifications;

import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.ClusterEntity_;
import com.netflix.genie.web.data.entities.CommandEntity_;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaSpecificationUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public final class JpaClusterSpecs {
    private JpaClusterSpecs() {
    }

    public static Specification<ClusterEntity> find(@Nullable String name, @Nullable Set<ClusterStatus> statuses, @Nullable Set<TagEntity> tags, @Nullable Instant minUpdateTime, @Nullable Instant maxUpdateTime) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ClusterEntity_.name), name));
            }
            if (minUpdateTime != null) {
                predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(ClusterEntity_.updated), (Comparable)minUpdateTime));
            }
            if (maxUpdateTime != null) {
                predicates.add(cb.lessThan((Expression)root.get(ClusterEntity_.updated), (Comparable)maxUpdateTime));
            }
            if (tags != null && !tags.isEmpty()) {
                SetJoin tagEntityJoin = root.join(ClusterEntity_.tags);
                predicates.add(tagEntityJoin.in((Collection)tags));
                cq.groupBy(new Expression[]{root.get(ClusterEntity_.id)});
                cq.having((Expression)cb.equal(cb.count((Expression)root.get(ClusterEntity_.id)), (Object)tags.size()));
            }
            if (statuses != null && !statuses.isEmpty()) {
                predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(ClusterEntity_.status), status)).toArray(Predicate[]::new)));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    public static Specification<ClusterEntity> findClustersForCommand(String commandId, @Nullable Set<ClusterStatus> statuses) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ListJoin commands = root.join(ClusterEntity_.commands);
            predicates.add(cb.equal((Expression)commands.get(CommandEntity_.uniqueId), (Object)commandId));
            if (statuses != null && !statuses.isEmpty()) {
                predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(ClusterEntity_.status), status)).toArray(Predicate[]::new)));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }
}

