/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.repositories.jpa.specifications;

import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.web.data.entities.ApplicationEntity_;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.CommandEntity_;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaSpecificationUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public final class JpaCommandSpecs {
    private JpaCommandSpecs() {
    }

    public static Specification<CommandEntity> find(@Nullable String name, @Nullable String user, @Nullable Set<CommandStatus> statuses, @Nullable Set<TagEntity> tags) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(CommandEntity_.name), name));
            }
            if (StringUtils.isNotBlank((CharSequence)user)) {
                predicates.add(JpaSpecificationUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(CommandEntity_.user), user));
            }
            if (statuses != null && !statuses.isEmpty()) {
                predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(CommandEntity_.status), status)).toArray(Predicate[]::new)));
            }
            if (tags != null && !tags.isEmpty()) {
                SetJoin tagEntityJoin = root.join(CommandEntity_.tags);
                predicates.add(tagEntityJoin.in((Collection)tags));
                cq.groupBy(new Expression[]{root.get(CommandEntity_.id)});
                cq.having((Expression)cb.equal(cb.count((Expression)root.get(CommandEntity_.id)), (Object)tags.size()));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }

    public static Specification<CommandEntity> findCommandsForApplication(String applicationId, @Nullable Set<CommandStatus> statuses) {
        return (Specification & Serializable)(root, cq, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ListJoin application = root.join(CommandEntity_.applications);
            predicates.add(cb.equal((Expression)application.get(ApplicationEntity_.uniqueId), (Object)applicationId));
            if (statuses != null && !statuses.isEmpty()) {
                predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(CommandEntity_.status), status)).toArray(Predicate[]::new)));
            }
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };
    }
}

