/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.common.internal.dto.v4.ClusterRequest;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.common.internal.dto.v4.Criterion;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;

@Validated
public interface ClusterPersistenceService {
    public String createCluster(@NotNull(message="No cluster request entered. Unable to create.") @Valid @NotNull(message="No cluster request entered. Unable to create.") @Valid ClusterRequest var1) throws GenieException;

    public Cluster getCluster(@NotBlank(message="No id entered. Unable to get.") @NotBlank(message="No id entered. Unable to get.") String var1) throws GenieException;

    public Page<Cluster> getClusters(@Nullable String var1, @Nullable Set<ClusterStatus> var2, @Nullable Set<String> var3, @Nullable Instant var4, @Nullable Instant var5, Pageable var6);

    public Map<Cluster, String> findClustersAndCommandsForJob(@NotNull(message="JobRequest object is null. Unable to continue.") @NotNull(message="JobRequest object is null. Unable to continue.") JobRequest var1) throws GenieException;

    public Map<Cluster, String> findClustersAndCommandsForCriteria(@NotEmpty List<@NotNull Criterion> var1, @NotNull Criterion var2) throws GenieException;

    public void updateCluster(@NotBlank(message="No cluster id entered. Unable to update.") @NotBlank(message="No cluster id entered. Unable to update.") String var1, @NotNull(message="No cluster information entered. Unable to update.") @Valid @NotNull(message="No cluster information entered. Unable to update.") @Valid Cluster var2) throws GenieException;

    public void patchCluster(@NotBlank String var1, @NotNull JsonPatch var2) throws GenieException;

    public void deleteAllClusters() throws GenieException;

    public void deleteCluster(@NotBlank(message="No id entered unable to delete.") @NotBlank(message="No id entered unable to delete.") String var1) throws GenieException;

    public void addConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to add configurations.") @NotBlank(message="No cluster id entered. Unable to add configurations.") String var1, @NotEmpty(message="No configuration files entered. Unable to add.") @NotEmpty(message="No configuration files entered. Unable to add.") Set<String> var2) throws GenieException;

    public Set<String> getConfigsForCluster(@NotBlank(message="No cluster id sent. Cannot retrieve configurations.") @NotBlank(message="No cluster id sent. Cannot retrieve configurations.") String var1) throws GenieException;

    public void updateConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to update configurations.") @NotBlank(message="No cluster id entered. Unable to update configurations.") String var1, @NotEmpty(message="No configs entered. Unable to update.") @NotEmpty(message="No configs entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to remove configs.") @NotBlank(message="No cluster id entered. Unable to remove configs.") String var1) throws GenieException;

    public void addDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to add dependencies.") @NotBlank(message="No cluster id entered. Unable to add dependencies.") String var1, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> var2) throws GenieException;

    public Set<String> getDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to get dependencies.") @NotBlank(message="No cluster id entered. Unable to get dependencies.") String var1) throws GenieException;

    public void updateDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to update dependencies.") @NotBlank(message="No cluster id entered. Unable to update dependencies.") String var1, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to remove dependencies.") @NotBlank(message="No cluster id entered. Unable to remove dependencies.") String var1) throws GenieException;

    public void removeDependencyForCluster(@NotBlank(message="No cluster id entered. Unable to remove dependency.") @NotBlank(message="No cluster id entered. Unable to remove dependency.") String var1, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String var2) throws GenieException;

    public void addTagsForCluster(@NotBlank(message="No cluster id entered. Unable to add tags.") @NotBlank(message="No cluster id entered. Unable to add tags.") String var1, @NotEmpty(message="No tags entered. Unable to add to tags.") @NotEmpty(message="No tags entered. Unable to add to tags.") Set<String> var2) throws GenieException;

    public Set<String> getTagsForCluster(@NotBlank(message="No cluster id sent. Cannot retrieve tags.") @NotBlank(message="No cluster id sent. Cannot retrieve tags.") String var1) throws GenieException;

    public void updateTagsForCluster(@NotBlank(message="No cluster id entered. Unable to update tags.") @NotBlank(message="No cluster id entered. Unable to update tags.") String var1, @NotEmpty(message="No tags entered. Unable to update.") @NotEmpty(message="No tags entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllTagsForCluster(@NotBlank(message="No cluster id entered. Unable to remove tags.") @NotBlank(message="No cluster id entered. Unable to remove tags.") String var1) throws GenieException;

    public void removeTagForCluster(@NotBlank(message="No cluster id entered. Unable to remove tag.") @NotBlank(message="No cluster id entered. Unable to remove tag.") String var1, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String var2) throws GenieException;

    public void addCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to add commands.") @NotBlank(message="No cluster id entered. Unable to add commands.") String var1, @NotEmpty(message="No command ids entered. Unable to add commands.") @NotEmpty(message="No command ids entered. Unable to add commands.") List<String> var2) throws GenieException;

    public List<Command> getCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to get commands.") @NotBlank(message="No cluster id entered. Unable to get commands.") String var1, @Nullable Set<CommandStatus> var2) throws GenieException;

    public void setCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to update commands.") @NotBlank(message="No cluster id entered. Unable to update commands.") String var1, @NotNull(message="No command ids entered. Unable to update commands.") @NotNull(message="No command ids entered. Unable to update commands.") List<String> var2) throws GenieException;

    public void removeAllCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to remove commands.") @NotBlank(message="No cluster id entered. Unable to remove commands.") String var1) throws GenieException;

    public void removeCommandForCluster(@NotBlank(message="No cluster id entered. Unable to remove command.") @NotBlank(message="No cluster id entered. Unable to remove command.") String var1, @NotBlank(message="No command id entered. Unable to remove command.") @NotBlank(message="No command id entered. Unable to remove command.") String var2) throws GenieException;

    public long deleteTerminatedClusters();
}

