/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.netflix.genie.web.data.entities.AgentConnectionEntity;
import com.netflix.genie.web.data.repositories.jpa.JpaAgentConnectionRepository;
import com.netflix.genie.web.data.services.AgentConnectionPersistenceService;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class JpaAgentConnectionPersistenceServiceImpl
implements AgentConnectionPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaAgentConnectionPersistenceServiceImpl.class);
    private final JpaAgentConnectionRepository agentConnectionRepository;

    public JpaAgentConnectionPersistenceServiceImpl(JpaAgentConnectionRepository agentConnectionRepository) {
        this.agentConnectionRepository = agentConnectionRepository;
    }

    @Override
    public void saveAgentConnection(@NotBlank String jobId, @NotBlank String hostname) {
        Optional<AgentConnectionEntity> existingEntity = this.getAgentConnection(jobId);
        if (existingEntity.isPresent()) {
            existingEntity.get().setServerHostname(hostname);
        } else {
            AgentConnectionEntity newEntity = this.toEntity(jobId, hostname);
            this.agentConnectionRepository.save(newEntity);
        }
    }

    @Override
    public void removeAgentConnection(@NotBlank String jobId, @NotBlank String hostname) {
        Optional<AgentConnectionEntity> existingEntity = this.getAgentConnection(jobId);
        if (existingEntity.isPresent() && existingEntity.get().getServerHostname().equals(hostname)) {
            this.agentConnectionRepository.delete(existingEntity.get());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<String> lookupAgentConnectionServer(@NotBlank String jobId) {
        Optional<AgentConnectionEntity> agentConnectionEntity = this.agentConnectionRepository.findByJobId(jobId);
        return agentConnectionEntity.map(AgentConnectionEntity::getServerHostname);
    }

    @Override
    @Transactional(readOnly=true)
    public long getNumAgentConnectionsOnServer(@NotBlank String hostname) {
        return this.agentConnectionRepository.countByServerHostnameEquals(hostname);
    }

    private Optional<AgentConnectionEntity> getAgentConnection(@NotBlank String jobId) {
        return this.agentConnectionRepository.findByJobId(jobId);
    }

    private AgentConnectionEntity toEntity(@NotBlank String jobId, @NotBlank String hostname) {
        return new AgentConnectionEntity(jobId, hostname);
    }
}

