/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.events;

import com.amazonaws.services.sns.AmazonSNS;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.web.events.AbstractSNSPublisher;
import com.netflix.genie.web.events.JobStateChangeEvent;
import com.netflix.genie.web.properties.SNSNotificationsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class JobStateChangeSNSPublisher
extends AbstractSNSPublisher
implements ApplicationListener<JobStateChangeEvent> {
    private static final Logger log = LoggerFactory.getLogger(JobStateChangeSNSPublisher.class);
    private static final String JOB_ID_KEY_NAME = "jobId";
    private static final String FROM_STATE_KEY_NAME = "fromState";
    private static final String TO_STATE_KEY_NAME = "toState";

    public JobStateChangeSNSPublisher(AmazonSNS snsClient, SNSNotificationsProperties properties, MeterRegistry registry, ObjectMapper mapper) {
        super(properties, registry, snsClient, mapper);
    }

    public void onApplicationEvent(JobStateChangeEvent event) {
        if (!this.properties.isEnabled()) {
            return;
        }
        String jobId = event.getJobId();
        JobStatus fromState = event.getPreviousStatus();
        JobStatus toState = event.getNewStatus();
        HashMap eventDetailsMap = Maps.newHashMap();
        eventDetailsMap.put(JOB_ID_KEY_NAME, jobId);
        eventDetailsMap.put(FROM_STATE_KEY_NAME, fromState != null ? fromState.name() : "null");
        eventDetailsMap.put(TO_STATE_KEY_NAME, toState.name());
        this.publishEvent(AbstractSNSPublisher.EventType.JOB_STATUS_CHANGE, eventDetailsMap);
    }
}

