/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class LocalAgentLauncherHealthIndicator
implements HealthIndicator {
    @VisibleForTesting
    static final String NUMBER_RUNNING_JOBS_KEY = "numRunningJobs";
    @VisibleForTesting
    static final String ALLOCATED_MEMORY_KEY = "allocatedMemory";
    @VisibleForTesting
    static final String USED_MEMORY_KEY = "usedMemory";
    @VisibleForTesting
    static final String AVAILABLE_MEMORY = "availableMemory";
    @VisibleForTesting
    static final String AVAILABLE_MAX_JOB_CAPACITY = "availableMaxJobCapacity";
    private final JobSearchService jobSearchService;
    private final LocalAgentLauncherProperties launcherProperties;
    private final String hostname;

    public LocalAgentLauncherHealthIndicator(JobSearchService jobSearchService, LocalAgentLauncherProperties launcherProperties, GenieHostInfo genieHostInfo) {
        this.jobSearchService = jobSearchService;
        this.launcherProperties = launcherProperties;
        this.hostname = genieHostInfo.getHostname();
    }

    public Health health() {
        int maxJobMemory;
        long allocatedMemoryOnHost = this.jobSearchService.getAllocatedMemoryOnHost(this.hostname);
        long usedMemoryOnHost = this.jobSearchService.getUsedMemoryOnHost(this.hostname);
        long availableMemory = this.launcherProperties.getMaxTotalJobMemory() - allocatedMemoryOnHost;
        Health.Builder builder = availableMemory >= (long)(maxJobMemory = this.launcherProperties.getMaxJobMemory()) ? Health.up() : Health.down();
        return builder.withDetail(NUMBER_RUNNING_JOBS_KEY, (Object)this.jobSearchService.getActiveJobCountOnHost(this.hostname)).withDetail(ALLOCATED_MEMORY_KEY, (Object)allocatedMemoryOnHost).withDetail(AVAILABLE_MEMORY, (Object)availableMemory).withDetail(USED_MEMORY_KEY, (Object)usedMemoryOnHost).withDetail(AVAILABLE_MAX_JOB_CAPACITY, (Object)(availableMemory >= 0L && maxJobMemory > 0 ? availableMemory / (long)maxJobMemory : 0L)).build();
    }
}

