/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.google.common.collect.Lists;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.launcher.local")
@Validated
public class LocalAgentLauncherProperties {
    public static final String PROPERTY_PREFIX = "genie.agent.launcher.local";
    @NotEmpty(message="The agent executable cannot be empty or it will be impossible to launch an agent process")
    private @NotEmpty(message="The agent executable cannot be empty or it will be impossible to launch an agent process") List<@NotBlank String> executable = Lists.newArrayList((Object[])new String[]{"java", "-jar", "/tmp/genie-agent.jar"});
    @Min(value=1L, message="The minimum value is 1MB but the value should likely be much higher")
    private @Min(value=1L, message="The minimum value is 1MB but the value should likely be much higher") int maxJobMemory = 10240;
    @Min(value=1L, message="The minimum value is 1MB but the value should likely be set much higher")
    private @Min(value=1L, message="The minimum value is 1MB but the value should likely be set much higher") long maxTotalJobMemory = 30720L;

    public List<String> getExecutable() {
        return this.executable;
    }

    public int getMaxJobMemory() {
        return this.maxJobMemory;
    }

    public long getMaxTotalJobMemory() {
        return this.maxTotalJobMemory;
    }

    public void setExecutable(List<String> executable) {
        this.executable = executable;
    }

    public void setMaxJobMemory(int maxJobMemory) {
        this.maxJobMemory = maxJobMemory;
    }

    public void setMaxTotalJobMemory(long maxTotalJobMemory) {
        this.maxTotalJobMemory = maxTotalJobMemory;
    }
}

