/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.net.URI;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.clusters.load-balancers.script")
@Validated
public class ScriptLoadBalancerProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.clusters.load-balancers.script";
    public static final String ENABLED_PROPERTY = "genie.jobs.clusters.load-balancers.script.enabled";
    public static final String REFRESH_RATE_PROPERTY = "genie.jobs.clusters.load-balancers.script.refreshRate";
    public static final String SCRIPT_FILE_DESTINATION_PROPERTY = "genie.jobs.clusters.load-balancers.script.destination";
    public static final String SCRIPT_FILE_SOURCE_PROPERTY = "genie.jobs.clusters.load-balancers.script.source";
    public static final String TIMEOUT_PROPERTY = "genie.jobs.clusters.load-balancers.script.timeout";
    private static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir", "/tmp/");
    private boolean enabled;
    @Min(value=1L)
    private @Min(value=1L) long refreshRate = 300000L;
    @NotNull
    private URI destination = URI.create("file://" + SYSTEM_TMP_DIR + "genie/loadbalancers/script/destination/");
    @NotNull
    private URI source = URI.create("file://" + SYSTEM_TMP_DIR + "genie/loadBalancers/script/source/loadBalance.js");
    @Min(value=1L)
    private @Min(value=1L) long timeout = 5000L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public URI getDestination() {
        return this.destination;
    }

    public URI getSource() {
        return this.source;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRefreshRate(long refreshRate) {
        this.refreshRate = refreshRate;
    }

    public void setDestination(URI destination) {
        this.destination = destination;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

