/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.internal.dto.v4.Application;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobFinishedEvent;
import com.netflix.genie.web.events.JobFinishedReason;
import com.netflix.genie.web.events.JobStartedEvent;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.WorkflowTask;
import com.netflix.genie.web.services.JobSubmitterService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class LocalJobRunner
implements JobSubmitterService {
    private static final Logger log = LoggerFactory.getLogger(LocalJobRunner.class);
    private final JobPersistenceService jobPersistenceService;
    private final List<WorkflowTask> jobWorkflowTasks;
    private final Resource baseWorkingDirPath;
    private final GenieEventBus genieEventBus;
    private final Timer overallSubmitTimer;
    private final Timer createJobDirTimer;
    private final Timer createRunScriptTimer;
    private final Timer executeJobTimer;
    private final Timer saveJobExecutionTimer;
    private final Timer publishJobStartedEventTimer;
    private final Timer createInitFailureDetailsFileTimer;

    public LocalJobRunner(@NotNull JobPersistenceService jobPersistenceService, @NonNull GenieEventBus genieEventBus, @NotNull List<WorkflowTask> workflowTasks, @NotNull Resource genieWorkingDir, @NotNull MeterRegistry registry) {
        if (genieEventBus == null) {
            throw new NullPointerException("genieEventBus is marked @NonNull but is null");
        }
        this.jobPersistenceService = jobPersistenceService;
        this.genieEventBus = genieEventBus;
        this.jobWorkflowTasks = workflowTasks;
        this.baseWorkingDirPath = genieWorkingDir;
        this.overallSubmitTimer = registry.timer("genie.jobs.submit.localRunner.overall.timer", new String[0]);
        this.createJobDirTimer = registry.timer("genie.jobs.submit.localRunner.createJobDir.timer", new String[0]);
        this.createRunScriptTimer = registry.timer("genie.jobs.submit.localRunner.createRunScript.timer", new String[0]);
        this.executeJobTimer = registry.timer("genie.jobs.submit.localRunner.executeJob.timer", new String[0]);
        this.saveJobExecutionTimer = registry.timer("genie.jobs.submit.localRunner.saveJobExecution.timer", new String[0]);
        this.publishJobStartedEventTimer = registry.timer("genie.jobs.submit.localRunner.publishJobStartedEvent.timer", new String[0]);
        this.createInitFailureDetailsFileTimer = registry.timer("genie.jobs.submit.localRunner.createInitFailureDetailsFile.timer", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="We catch exception to make sure we always mark job failed.")
    public void submitJob(@NotNull(message="No job provided. Unable to submit job for execution.") @Valid @NotNull(message="No job provided. Unable to submit job for execution.") @Valid JobRequest jobRequest, @NotNull(message="No cluster provided. Unable to submit job for execution") @Valid @NotNull(message="No cluster provided. Unable to submit job for execution") @Valid Cluster cluster, @NotNull(message="No command provided. Unable to submit job for execution") @Valid @NotNull(message="No command provided. Unable to submit job for execution") @Valid Command command, @NotNull(message="No applications provided. Unable to execute") @NotNull(message="No applications provided. Unable to execute") List<Application> applications, @Min(value=1L, message="Memory can't be less than 1 MB") @Min(value=1L, message="Memory can't be less than 1 MB") int memory) throws GenieException {
        block12: {
            long start = System.nanoTime();
            try {
                log.info("Beginning local job submission for {}", (Object)jobRequest);
                String id = (String)jobRequest.getId().orElseThrow(() -> new GenieServerException("No job id found."));
                try {
                    File jobWorkingDir = this.createJobWorkingDirectory(id);
                    File runScript = this.createRunScript(jobWorkingDir);
                    Map<String, Object> context = this.createJobContext(jobRequest, cluster, command, applications, memory, jobWorkingDir);
                    JobExecution jobExecution = this.executeJob(context, runScript);
                    if (jobExecution == null) break block12;
                    long createJobExecutionStart = System.nanoTime();
                    try {
                        log.info("Saving job execution for job {}", (Object)jobRequest.getId());
                        this.jobPersistenceService.setJobRunningInformation(id, (Integer)jobExecution.getProcessId().orElseThrow(() -> new GenieServerException("No process id returned. Unable to persist")), jobExecution.getCheckDelay().orElse(10000L), (Instant)jobExecution.getTimeout().orElseThrow(() -> new GenieServerException("No timeout date returned. Unable to persist")));
                    }
                    finally {
                        this.saveJobExecutionTimer.record(System.nanoTime() - createJobExecutionStart, TimeUnit.NANOSECONDS);
                    }
                    long publishEventStart = System.nanoTime();
                    try {
                        log.info("Publishing job started event for job {}", (Object)id);
                        this.genieEventBus.publishSynchronousEvent(new JobStartedEvent(jobExecution, (Object)this));
                    }
                    finally {
                        this.publishJobStartedEventTimer.record(System.nanoTime() - publishEventStart, TimeUnit.NANOSECONDS);
                    }
                }
                catch (GeniePreconditionException gpe) {
                    log.error(gpe.getMessage(), (Throwable)gpe);
                    this.createInitFailureDetailsFile(id, (Exception)((Object)gpe));
                    this.genieEventBus.publishAsynchronousEvent(new JobFinishedEvent(id, JobFinishedReason.INVALID, "Job validation failed, further details available in the job output directory", this));
                    throw gpe;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.createInitFailureDetailsFile(id, e);
                    this.genieEventBus.publishAsynchronousEvent(new JobFinishedEvent(id, JobFinishedReason.FAILED_TO_INIT, "Job initialization failed, further details available in the job output directory", this));
                    throw e;
                }
            }
            finally {
                this.overallSubmitTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitFailureDetailsFile(String id, Exception e) {
        block20: {
            long start = System.nanoTime();
            try {
                File jobDir = new File(this.baseWorkingDirPath.getFile(), id);
                if (jobDir.exists()) {
                    boolean detailsFileExists;
                    File detailsFile = new File(jobDir, "initFailureDetails.txt");
                    boolean bl = detailsFileExists = !detailsFile.createNewFile();
                    if (detailsFileExists) {
                        log.warn("Init failure details file exists");
                    }
                    try (PrintWriter p = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(detailsFile), StandardCharsets.UTF_8));){
                        p.format(" *** Initialization failure for job: %s ***%n%nException: %s - %s%nTrace:%n", id, e.getClass().getCanonicalName(), e.getMessage());
                        e.printStackTrace(p);
                    }
                    log.info("Created init failure details file {}", (Object)detailsFile);
                    break block20;
                }
                log.error("Could not create init failure details file, job directory does not exist");
            }
            catch (Throwable t) {
                log.error("Failed to create init failure details file", t);
            }
            finally {
                this.createInitFailureDetailsFileTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }

    private File createJobWorkingDirectory(String id) throws GenieException {
        long start = System.nanoTime();
        try {
            File jobDir = new File(this.baseWorkingDirPath.getFile(), id);
            if (!jobDir.mkdirs()) {
                throw new GenieServerException("Could not create job working directory directory: " + jobDir.getCanonicalPath());
            }
            log.info("Created job dir {}", (Object)jobDir);
            File file = jobDir;
            return file;
        }
        catch (IOException ioe) {
            throw new GenieServerException("Could not resolve job working directory due to exception", (Throwable)ioe);
        }
        finally {
            this.createJobDirTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createRunScript(File jobWorkingDir) throws GenieException {
        long start = System.nanoTime();
        try {
            File runScript = new File(jobWorkingDir, "run");
            if (!runScript.exists()) {
                try {
                    if (!runScript.createNewFile()) {
                        throw new GenieServerException("Unable to create run script file due to unknown reason.");
                    }
                }
                catch (IOException ioe) {
                    throw new GenieServerException("Unable to create run script file due to IOException.", (Throwable)ioe);
                }
            }
            if (!runScript.setExecutable(true)) {
                throw new GenieServerException("Unable to make run script executable");
            }
            log.info("Created run script {}", (Object)runScript);
            File file = runScript;
            return file;
        }
        finally {
            this.createRunScriptTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Map<String, Object> createJobContext(JobRequest jobRequest, Cluster cluster, Command command, List<Application> applications, int memory, File jobWorkingDir) throws GenieException {
        JobExecutionEnvironment jee = new JobExecutionEnvironment.Builder(jobRequest, cluster, command, memory, jobWorkingDir).withApplications(applications).build();
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("jee", jee);
        return context;
    }

    /*
     * Exception decompiling
     */
    private JobExecution executeJob(Map<String, Object> context, File runScript) throws GenieException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ GenieServerException lambda$executeJob$3() {
        return new GenieServerException("No job id. Unable to execute");
    }
}

