/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.loadbalancers.script;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.web.apis.rest.v3.controllers.DtoConverters;
import com.netflix.genie.web.services.ClusterLoadBalancer;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;

public class ScriptLoadBalancer
implements ClusterLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(ScriptLoadBalancer.class);
    static final String SELECT_TIMER_NAME = "genie.jobs.clusters.loadBalancers.script.select.timer";
    static final String UPDATE_TIMER_NAME = "genie.jobs.clusters.loadBalancers.script.update.timer";
    static final String STATUS_TAG_OK = "ok";
    static final String STATUS_TAG_NOT_FOUND = "not found";
    static final String STATUS_TAG_NOT_CONFIGURED = "not configured";
    static final String STATUS_TAG_FOUND = "found";
    static final String STATUS_TAG_FAILED = "failed";
    static final String STATUS_TAG_NO_PREFERENCE = "no preference";
    private static final long DEFAULT_TIMEOUT_LENGTH = 5000L;
    private static final String SLASH = "/";
    private static final String PERIOD = ".";
    private static final String CLUSTERS_BINDING = "clusters";
    private static final String JOB_REQUEST_BINDING = "jobRequest";
    private final MeterRegistry registry;
    private final Loader loader;
    private final Evaluator evaluator;

    public ScriptLoadBalancer(AsyncTaskExecutor asyncTaskExecutor, TaskScheduler taskScheduler, GenieFileTransferService fileTransferService, Environment environment, ObjectMapper mapper, MeterRegistry registry) {
        this(new Loader(taskScheduler, environment, fileTransferService, registry), new Evaluator(mapper, asyncTaskExecutor, (Long)environment.getProperty("genie.jobs.clusters.load-balancers.script.timeout", Long.class, (Object)5000L)), registry);
    }

    private ScriptLoadBalancer(Loader loader, Evaluator evaluator, MeterRegistry registry) {
        this.loader = loader;
        this.evaluator = evaluator;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster selectCluster(@Nonnull @NotEmpty @NonNull Set<Cluster> clusters, @Nonnull @NonNull JobRequest jobRequest) throws GenieException {
        if (clusters == null) {
            throw new NullPointerException("clusters is marked @NonNull but is null");
        }
        if (jobRequest == null) {
            throw new NullPointerException("jobRequest is marked @NonNull but is null");
        }
        long selectStart = System.nanoTime();
        log.debug("Called");
        HashSet tags = Sets.newHashSet();
        try {
            CompiledScript script = this.loader.get();
            if (script == null) {
                log.debug("Script not configured");
                tags.add(Tag.of((String)"status", (String)STATUS_TAG_NOT_CONFIGURED));
                Cluster cluster = null;
                return cluster;
            }
            String clusterId = this.evaluator.evaluate(script, jobRequest, clusters);
            if (clusterId == null) {
                tags.add(Tag.of((String)"status", (String)STATUS_TAG_NO_PREFERENCE));
                log.debug("Script returned null, no preference");
                Cluster cluster = null;
                return cluster;
            }
            for (Cluster cluster : clusters) {
                if (!clusterId.equals(cluster.getId())) continue;
                tags.add(Tag.of((String)"status", (String)STATUS_TAG_FOUND));
                tags.add(Tag.of((String)"clusterName", (String)cluster.getMetadata().getName()));
                tags.add(Tag.of((String)"clusterId", (String)cluster.getId()));
                Cluster cluster2 = cluster;
                return cluster2;
            }
            log.warn("Script returned a cluster not in the input list: {}", (Object)clusterId);
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_NOT_FOUND));
            Iterator<Cluster> iterator = null;
            return iterator;
        }
        catch (Exception e) {
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_FAILED));
            tags.add(Tag.of((String)"exceptionClass", (String)e.getClass().getCanonicalName()));
            log.error("Unable to execute script due to {}", (Object)e.getMessage(), (Object)e);
            Cluster cluster = null;
            return cluster;
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }

    protected static class Loader {
        private final AtomicBoolean isUpdating = new AtomicBoolean();
        private final AtomicBoolean isConfigured = new AtomicBoolean();
        private final AtomicReference<CompiledScript> script = new AtomicReference<Object>(null);
        private final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        private final Environment environment;
        private final MeterRegistry registry;
        private final GenieFileTransferService fileTransferService;

        protected Loader(TaskScheduler taskScheduler, Environment environment, GenieFileTransferService fileTransferService, MeterRegistry registry) {
            this.environment = environment;
            this.registry = registry;
            this.fileTransferService = fileTransferService;
            long refreshRate = (Long)environment.getProperty("genie.jobs.clusters.load-balancers.script.refreshRate", Long.class, (Object)300000L);
            taskScheduler.scheduleWithFixedDelay(this::refresh, refreshRate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void refresh() {
            log.debug("Refreshing");
            long updateStart = System.nanoTime();
            HashSet tags = Sets.newHashSet();
            try {
                this.isUpdating.set(true);
                String scriptFileSourceValue = this.environment.getProperty("genie.jobs.clusters.load-balancers.script.source");
                if (StringUtils.isBlank((CharSequence)scriptFileSourceValue)) {
                    throw new IllegalStateException("Invalid empty value for script source file property: genie.jobs.clusters.load-balancers.script.source");
                }
                String scriptFileSource = new URI(scriptFileSourceValue).toString();
                String scriptFileDestinationValue = this.environment.getProperty("genie.jobs.clusters.load-balancers.script.destination");
                if (StringUtils.isBlank((CharSequence)scriptFileDestinationValue)) {
                    throw new IllegalStateException("Invalid empty value for script destination directory property: genie.jobs.clusters.load-balancers.script.destination");
                }
                Path scriptDestinationDirectory = Paths.get(new URI(scriptFileDestinationValue));
                if (!Files.exists(scriptDestinationDirectory, new LinkOption[0])) {
                    Files.createDirectories(scriptDestinationDirectory, new FileAttribute[0]);
                } else if (!Files.isDirectory(scriptDestinationDirectory, new LinkOption[0])) {
                    throw new IllegalStateException("The script destination directory " + scriptDestinationDirectory + " exists but is not a directory");
                }
                String fileName = StringUtils.substringAfterLast((String)scriptFileSource, (String)ScriptLoadBalancer.SLASH);
                if (StringUtils.isBlank((CharSequence)fileName)) {
                    throw new IllegalStateException("No file name found from " + scriptFileSource);
                }
                String scriptExtension = StringUtils.substringAfterLast((String)fileName, (String)ScriptLoadBalancer.PERIOD);
                if (StringUtils.isBlank((CharSequence)scriptExtension)) {
                    throw new IllegalStateException("No file extension available in " + fileName);
                }
                Path scriptDestinationPath = scriptDestinationDirectory.resolve(fileName);
                this.fileTransferService.getFile(scriptFileSource, scriptDestinationPath.toUri().toString());
                ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(scriptExtension);
                if (!(engine instanceof Compilable)) {
                    throw new IllegalArgumentException("Script engine must be of type " + Compilable.class.getName());
                }
                Compilable compilable = (Compilable)((Object)engine);
                try (InputStream fis = Files.newInputStream(scriptDestinationPath, new OpenOption[0]);
                     InputStreamReader reader = new InputStreamReader(fis, StandardCharsets.UTF_8);){
                    log.debug("Compiling {}", (Object)scriptFileSource);
                    this.script.set(compilable.compile(reader));
                }
                tags.add(Tag.of((String)"status", (String)ScriptLoadBalancer.STATUS_TAG_OK));
                this.isConfigured.set(true);
            }
            catch (GenieException | IOException | RuntimeException | URISyntaxException | ScriptException e) {
                tags.add(Tag.of((String)"status", (String)ScriptLoadBalancer.STATUS_TAG_FAILED));
                tags.add(Tag.of((String)"exceptionClass", (String)e.getClass().getName()));
                log.error("Refreshing the load balancing script for ScriptLoadBalancer failed due to {}", (Object)e.getMessage(), (Object)e);
                this.isConfigured.set(false);
            }
            finally {
                this.isUpdating.set(false);
                this.registry.timer(ScriptLoadBalancer.UPDATE_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - updateStart, TimeUnit.NANOSECONDS);
                log.debug("Refresh completed");
            }
        }

        @Nullable
        protected CompiledScript get() {
            return this.script.get();
        }
    }

    protected static class Evaluator {
        private final ObjectMapper mapper;
        private final AsyncTaskExecutor asyncTaskExecutor;
        private final long timeoutLength;

        protected Evaluator(ObjectMapper mapper, AsyncTaskExecutor asyncTaskExecutor, long timeoutLength) {
            this.mapper = mapper;
            this.asyncTaskExecutor = asyncTaskExecutor;
            this.timeoutLength = timeoutLength;
        }

        protected String evaluate(CompiledScript script, @NonNull JobRequest jobRequest, Set<Cluster> clusters) throws JsonProcessingException, InterruptedException, ExecutionException, TimeoutException {
            if (jobRequest == null) {
                throw new NullPointerException("jobRequest is marked @NonNull but is null");
            }
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(ScriptLoadBalancer.CLUSTERS_BINDING, (Object)this.mapper.writeValueAsString(clusters.stream().map(DtoConverters::toV3Cluster).collect(Collectors.toSet())));
            bindings.put(ScriptLoadBalancer.JOB_REQUEST_BINDING, (Object)this.mapper.writeValueAsString((Object)jobRequest));
            String clusterId = (String)this.asyncTaskExecutor.submit(() -> (String)script.eval(bindings)).get(this.timeoutLength, TimeUnit.MILLISECONDS);
            log.debug("Script evaluated with result: {}", (Object)clusterId);
            return clusterId;
        }
    }
}

