/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.apis.rpc.servers;

import com.netflix.genie.web.agent.apis.rpc.servers.GRpcServerManager;
import com.netflix.genie.web.properties.GRpcServerProperties;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GRpcServerProperties.class})
@AutoConfigureAfter(name={"com.netflix.springboot.grpc.server.GrpcServerAutoConfiguration"})
public class AgentRpcServersAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AgentRpcServersAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("gRPC server configuration is ENABLED");
    }

    @Bean
    @ConditionalOnMissingBean(value={Server.class})
    public Server gRpcServer(@Value(value="${grpc.server.port:0}") int port, Set<BindableService> services, List<ServerInterceptor> serverInterceptors) {
        NettyServerBuilder builder = NettyServerBuilder.forPort((int)port);
        services.stream().map(BindableService::bindService).map(serviceDefinition -> ServerInterceptors.intercept((ServerServiceDefinition)serviceDefinition, (List)serverInterceptors)).forEach(arg_0 -> ((NettyServerBuilder)builder).addService(arg_0));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(value={GRpcServerManager.class})
    public GRpcServerManager gRpcServerManager(Server server) {
        return new GRpcServerManager(server);
    }
}

