/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.inspectors;

import com.netflix.genie.web.agent.inspectors.impl.BlacklistedVersionAgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.impl.MinimumVersionAgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.impl.WhitelistedVersionAgentMetadataInspector;
import com.netflix.genie.web.properties.AgentFilterProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"genie.agent.filter.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={AgentFilterProperties.class})
public class AgentInspectorsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WhitelistedVersionAgentMetadataInspector.class})
    public WhitelistedVersionAgentMetadataInspector whitelistedVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new WhitelistedVersionAgentMetadataInspector(agentFilterProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlacklistedVersionAgentMetadataInspector.class})
    public BlacklistedVersionAgentMetadataInspector blacklistedVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new BlacklistedVersionAgentMetadataInspector(agentFilterProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={MinimumVersionAgentMetadataInspector.class})
    public MinimumVersionAgentMetadataInspector minimumVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new MinimumVersionAgentMetadataInspector(agentFilterProperties);
    }
}

