/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.services;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.services.AgentFilterService;
import com.netflix.genie.web.agent.services.AgentJobService;
import com.netflix.genie.web.agent.services.AgentMetricsService;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.agent.services.impl.AgentFilterServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentJobServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentMetricsServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentRoutingServiceImpl;
import com.netflix.genie.web.data.services.AgentConnectionPersistenceService;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.services.JobResolverService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AgentServicesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AgentJobService.class})
    public AgentJobService agentJobService(JobPersistenceService jobPersistenceService, JobResolverService jobResolverService, AgentFilterService agentFilterService, MeterRegistry meterRegistry) {
        return new AgentJobServiceImpl(jobPersistenceService, jobResolverService, agentFilterService, meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentRoutingService.class})
    public AgentRoutingService agentRoutingService(AgentConnectionPersistenceService agentConnectionPersistenceService, GenieHostInfo genieHostInfo) {
        return new AgentRoutingServiceImpl(agentConnectionPersistenceService, genieHostInfo);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentFilterService.class})
    public AgentFilterServiceImpl agentFilterService(List<AgentMetadataInspector> agentMetadataInspectorsList) {
        return new AgentFilterServiceImpl(agentMetadataInspectorsList);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentMetricsService.class})
    public AgentMetricsServiceImpl agentMetricsService(GenieHostInfo genieHostInfo, AgentConnectionPersistenceService agentConnectionPersistenceService, MeterRegistry registry) {
        return new AgentMetricsServiceImpl(genieHostInfo, agentConnectionPersistenceService, registry);
    }
}

