/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.aspects;

import com.netflix.genie.web.aspects.DataServiceRetryAspect;
import com.netflix.genie.web.aspects.HealthCheckMetricsAspect;
import com.netflix.genie.web.aspects.SystemArchitecture;
import com.netflix.genie.web.properties.DataServiceRetryProperties;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableConfigurationProperties(value={DataServiceRetryProperties.class})
@EnableAspectJAutoProxy
public class AspectsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataServiceRetryAspect.class})
    public DataServiceRetryAspect getDataServiceRetryAspect(DataServiceRetryProperties retryProperties) {
        return new DataServiceRetryAspect(retryProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthCheckMetricsAspect.class})
    public HealthCheckMetricsAspect healthCheckMetricsAspect(MeterRegistry meterRegistry) {
        return new HealthCheckMetricsAspect(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={SystemArchitecture.class})
    public SystemArchitecture systemArchitecture() {
        return new SystemArchitecture();
    }
}

