/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.properties.AgentCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentJobCleanupTask
extends LeadershipTask {
    private static final Logger log = LoggerFactory.getLogger(AgentJobCleanupTask.class);
    private static final String STATUS_MESSAGE = "Agent AWOL for too long";
    private static final String TERMINATED_COUNTER_METRIC_NAME = "genie.jobs.agentDisconnected.terminated.counter";
    private static final String DISCONNECTED_GAUGE_METRIC_NAME = "genie.jobs.agentDisconnected.gauge";
    private final Map<String, Instant> awolJobDeadlines;
    private final JobSearchService jobSearchService;
    private final JobPersistenceService jobPersistenceService;
    private final AgentCleanupProperties properties;
    private final MeterRegistry registry;

    public AgentJobCleanupTask(JobSearchService jobSearchService, JobPersistenceService jobPersistenceService, AgentCleanupProperties properties, MeterRegistry registry) {
        this.jobSearchService = jobSearchService;
        this.jobPersistenceService = jobPersistenceService;
        this.properties = properties;
        this.registry = registry;
        this.awolJobDeadlines = Maps.newConcurrentMap();
        this.registry.gaugeMapSize(DISCONNECTED_GAUGE_METRIC_NAME, (Iterable)Sets.newHashSet(), this.awolJobDeadlines);
    }

    @Override
    public void run() {
        Set<String> currentlyAwolJobsIds = this.jobSearchService.getActiveDisconnectedAgentJobs();
        this.awolJobDeadlines.entrySet().removeIf(awolJobEntry -> !currentlyAwolJobsIds.contains(awolJobEntry.getKey()));
        Instant now = Instant.now();
        for (String awolJobId : currentlyAwolJobsIds) {
            Instant awolJobDeadline = this.awolJobDeadlines.get(awolJobId);
            if (awolJobDeadline == null) {
                log.debug("Starting to track AWOL job {}", (Object)awolJobId);
                this.awolJobDeadlines.put(awolJobId, now.plusMillis(this.properties.getTimeLimit()));
                continue;
            }
            if (now.isAfter(awolJobDeadline)) {
                log.debug("Job {} no longer AWOL", (Object)awolJobId);
                try {
                    this.jobPersistenceService.setJobCompletionInformation(awolJobId, -1, JobStatus.FAILED, STATUS_MESSAGE, null, null);
                    this.awolJobDeadlines.remove(awolJobId);
                    this.registry.counter(TERMINATED_COUNTER_METRIC_NAME, MetricsUtils.newSuccessTagsSet()).increment();
                }
                catch (GenieException e) {
                    log.warn("Failed to mark AWOL job {} as failed: ", (Object)awolJobId, (Object)e);
                    this.registry.counter(TERMINATED_COUNTER_METRIC_NAME, MetricsUtils.newFailureTagsSetForException(e)).increment();
                }
                continue;
            }
            log.debug("Job {} is still AWOL", (Object)awolJobId);
        }
    }

    @Override
    public void cleanup() {
        this.awolJobDeadlines.clear();
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_RATE;
    }

    @Override
    public long getFixedRate() {
        return this.properties.getRefreshInterval();
    }
}

