/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.genie.common.external.dtos.v4.JobMetadata;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.introspection.GenieWebHostInfo;
import com.netflix.genie.web.introspection.GenieWebRpcInfo;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.util.ExecutorFactory;
import com.netflix.genie.web.util.UNIXUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAgentLauncherImpl
implements AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(LocalAgentLauncherImpl.class);
    private static final String RUN_USER_PLACEHOLDER = "<GENIE_USER>";
    private static final String SETS_ID = "setsid";
    private static final Object MEMORY_CHECK_LOCK = new Object();
    private final String hostname;
    private final JobSearchService jobSearchService;
    private final LocalAgentLauncherProperties launcherProperties;
    private final ExecutorFactory executorFactory;
    private final MeterRegistry registry;
    private final Executor sharedExecutor;
    private int rpcPort;

    public LocalAgentLauncherImpl(GenieWebHostInfo hostInfo, GenieWebRpcInfo rpcInfo, JobSearchService jobSearchService, LocalAgentLauncherProperties launcherProperties, ExecutorFactory executorFactory, MeterRegistry registry) {
        this.hostname = hostInfo.getHostname();
        this.rpcPort = rpcInfo.getRpcPort();
        this.jobSearchService = jobSearchService;
        this.launcherProperties = launcherProperties;
        this.executorFactory = executorFactory;
        this.registry = registry;
        this.sharedExecutor = this.executorFactory.newInstance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchAgent(@Valid ResolvedJob resolvedJob) throws AgentLaunchException {
        log.debug("Received request to launch local agent to run job: {}", (Object)resolvedJob);
        JobMetadata jobMetadata = resolvedJob.getJobMetadata();
        String user = jobMetadata.getUser();
        if (this.launcherProperties.isRunAsUserEnabled()) {
            String group = jobMetadata.getGroup().orElse(null);
            try {
                UNIXUtils.createUser(user, group, this.sharedExecutor);
            }
            catch (IOException e) {
                log.error("Failed to create user {}: {}", new Object[]{jobMetadata.getUser(), e.getMessage(), e});
                throw new AgentLaunchException(e);
            }
        }
        int jobMemory = resolvedJob.getJobEnvironment().getMemory();
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        if (jobMemory > this.launcherProperties.getMaxJobMemory()) {
            throw new AgentLaunchException("Unable to launch job as the requested job memory (" + jobMemory + "MB) exceeds the maximum allowed by the configuration of the system (" + this.launcherProperties.getMaxJobMemory() + "MB)");
        }
        CommandLine commandLine = this.createCommandLine((Map<String, String>)ImmutableMap.of((Object)"<SERVER_PORT_PLACEHOLDER>", (Object)Integer.toString(this.rpcPort), (Object)"<JOB_ID_PLACEHOLDER>", (Object)jobId, (Object)RUN_USER_PLACEHOLDER, (Object)user, (Object)"<AGENT_JAR_PLACEHOLDER>", (Object)this.launcherProperties.getAgentJarPath()));
        Object object = MEMORY_CHECK_LOCK;
        synchronized (object) {
            long usedMemoryOnHost = this.jobSearchService.getUsedMemoryOnHost(this.hostname);
            long expectedUsedMemoryOnHost = usedMemoryOnHost + (long)jobMemory;
            if (expectedUsedMemoryOnHost > this.launcherProperties.getMaxTotalJobMemory()) {
                throw new AgentLaunchException("Running job " + jobId + " with " + jobMemory + "MB of memory would cause there to be more memory used than the configured amount of " + this.launcherProperties.getMaxTotalJobMemory() + "MB. " + usedMemoryOnHost + "MB worth of jobs are currently running on this node.");
            }
        }
        HashMap environment = Maps.newHashMap(System.getenv());
        environment.putAll(this.launcherProperties.getAdditionalEnvironment());
        log.debug("Launching agent: {}, env: {}", (Object)commandLine, (Object)environment);
        Executor executor = this.executorFactory.newInstance(true);
        if (this.launcherProperties.isProcessOutputCaptureEnabled()) {
            String debugOutputPath = System.getProperty(SystemUtils.JAVA_IO_TMPDIR, "/tmp") + "/agent-job-" + jobId + ".txt";
            try {
                FileOutputStream fileOutput = new FileOutputStream(debugOutputPath, false);
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)fileOutput));
            }
            catch (FileNotFoundException e) {
                log.error("Failed to create agent process output file", (Throwable)e);
            }
        }
        log.info("Launching agent for job {}", (Object)jobId);
        AgentResultHandler resultHandler = new AgentResultHandler(jobId);
        try {
            executor.execute(commandLine, (Map)environment, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException ioe) {
            throw new AgentLaunchException("Unable to launch agent using command: " + commandLine.toString(), ioe);
        }
    }

    private CommandLine createCommandLine(Map<String, String> argumentValueReplacements) {
        ArrayList commandLineTemplate = Lists.newArrayList();
        if (SystemUtils.IS_OS_LINUX) {
            commandLineTemplate.add(SETS_ID);
        }
        if (this.launcherProperties.isRunAsUserEnabled()) {
            commandLineTemplate.addAll(Lists.newArrayList((Object[])new String[]{"sudo", "-E", "-u", RUN_USER_PLACEHOLDER}));
        }
        commandLineTemplate.addAll(this.launcherProperties.getLaunchCommandTemplate());
        CommandLine commandLine = new CommandLine((String)commandLineTemplate.get(0));
        for (int i = 1; i < commandLineTemplate.size(); ++i) {
            String argument = (String)commandLineTemplate.get(i);
            commandLine.addArgument(argumentValueReplacements.getOrDefault(argument, argument));
        }
        return commandLine;
    }

    @VisibleForTesting
    static class AgentResultHandler
    extends DefaultExecuteResultHandler {
        private static final Logger log = LoggerFactory.getLogger(AgentResultHandler.class);
        private final String jobId;

        AgentResultHandler(String jobId) {
            this.jobId = jobId;
        }

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            log.info("Agent process for job {} completed with exit value {}", (Object)this.jobId, (Object)exitValue);
        }

        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            log.error("Agent process failed for job {} due to {}", new Object[]{this.jobId, e.getMessage(), e});
        }
    }
}

