/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.ApplicationRequest;
import com.netflix.genie.common.external.dtos.v4.ApplicationStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;

@Validated
public interface ApplicationPersistenceService {
    public String createApplication(@NotNull(message="No application entered to create.") @Valid @NotNull(message="No application entered to create.") @Valid ApplicationRequest var1) throws GenieException;

    public Application getApplication(@NotBlank(message="No id entered. Unable to get") @NotBlank(message="No id entered. Unable to get") String var1) throws GenieException;

    public Page<Application> getApplications(@Nullable String var1, @Nullable String var2, @Nullable Set<ApplicationStatus> var3, @Nullable Set<String> var4, @Nullable String var5, Pageable var6);

    public void updateApplication(@NotBlank(message="No application id entered. Unable to update.") @NotBlank(message="No application id entered. Unable to update.") String var1, @NotNull(message="No application information entered. Unable to update.") @Valid @NotNull(message="No application information entered. Unable to update.") @Valid Application var2) throws GenieException;

    public void patchApplication(@NotBlank String var1, @NotNull JsonPatch var2) throws GenieException;

    public void deleteAllApplications() throws GenieException;

    public void deleteApplication(@NotBlank(message="No application id entered. Unable to delete.") @NotBlank(message="No application id entered. Unable to delete.") String var1) throws GenieException;

    public void addConfigsToApplication(@NotBlank(message="No application id entered. Unable to add configurations.") @NotBlank(message="No application id entered. Unable to add configurations.") String var1, @NotEmpty(message="No configuration files entered.") @NotEmpty(message="No configuration files entered.") Set<String> var2) throws GenieException;

    public Set<String> getConfigsForApplication(@NotBlank(message="No application id entered. Unable to get configs.") @NotBlank(message="No application id entered. Unable to get configs.") String var1) throws GenieException;

    public void updateConfigsForApplication(@NotBlank(message="No application id entered. Unable to update configurations.") @NotBlank(message="No application id entered. Unable to update configurations.") String var1, @NotNull(message="No configs entered. Unable to update. If you want, use delete API.") @NotNull(message="No configs entered. Unable to update. If you want, use delete API.") Set<String> var2) throws GenieException;

    public void removeAllConfigsForApplication(@NotBlank(message="No application id entered. Unable to remove configs.") @NotBlank(message="No application id entered. Unable to remove configs.") String var1) throws GenieException;

    public void removeConfigForApplication(@NotBlank(message="No application id entered. Unable to remove configuration.") @NotBlank(message="No application id entered. Unable to remove configuration.") String var1, @NotBlank(message="No config entered. Unable to remove.") @NotBlank(message="No config entered. Unable to remove.") String var2) throws GenieException;

    public void addDependenciesForApplication(@NotBlank(message="No application id entered. Unable to add dependencies.") @NotBlank(message="No application id entered. Unable to add dependencies.") String var1, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> var2) throws GenieException;

    public Set<String> getDependenciesForApplication(@NotBlank(message="No application id entered. Unable to get dependencies.") @NotBlank(message="No application id entered. Unable to get dependencies.") String var1) throws GenieException;

    public void updateDependenciesForApplication(@NotBlank(message="No application id entered. Unable to update dependencies.") @NotBlank(message="No application id entered. Unable to update dependencies.") String var1, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> var2) throws GenieException;

    public void removeAllDependenciesForApplication(@NotBlank(message="No application id entered. Unable to remove dependencies.") @NotBlank(message="No application id entered. Unable to remove dependencies.") String var1) throws GenieException;

    public void removeDependencyForApplication(@NotBlank(message="No application id entered. Unable to remove dependency.") @NotBlank(message="No application id entered. Unable to remove dependency.") String var1, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String var2) throws GenieException;

    public void addTagsForApplication(@NotBlank(message="No application id entered. Unable to add tags.") @NotBlank(message="No application id entered. Unable to add tags.") String var1, @NotEmpty(message="No tags entered. Unable to add.") @NotEmpty(message="No tags entered. Unable to add.") Set<String> var2) throws GenieException;

    public Set<String> getTagsForApplication(@NotBlank(message="No application id entered. Cannot retrieve tags.") @NotBlank(message="No application id entered. Cannot retrieve tags.") String var1) throws GenieException;

    public void updateTagsForApplication(@NotBlank(message="No application id entered. Unable to update tags.") @NotBlank(message="No application id entered. Unable to update tags.") String var1, @NotNull(message="No tags entered unable to update tags.") @NotNull(message="No tags entered unable to update tags.") Set<String> var2) throws GenieException;

    public void removeAllTagsForApplication(@NotBlank(message="No application id entered. Unable to remove tags.") @NotBlank(message="No application id entered. Unable to remove tags.") String var1) throws GenieException;

    public void removeTagForApplication(@NotBlank(message="No application id entered. Unable to remove tag.") @NotBlank(message="No application id entered. Unable to remove tag.") String var1, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String var2) throws GenieException;

    public Set<Command> getCommandsForApplication(@NotBlank(message="No application id entered. Unable to get commands.") @NotBlank(message="No application id entered. Unable to get commands.") String var1, @Nullable Set<CommandStatus> var2) throws GenieException;
}

