/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services;

import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.FinishedJob;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.SaveAttachmentException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
public interface JobPersistenceService {
    public void createJob(@NotNull JobRequest var1, @NotNull JobMetadata var2, @NotNull Job var3, @NotNull JobExecution var4) throws GenieException;

    public void updateJobWithRuntimeEnvironment(@NotBlank String var1, @NotBlank String var2, @NotBlank String var3, @NotNull List<String> var4, @Min(value=1L) @Min(value=1L) int var5) throws GenieException;

    public void updateJobStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") com.netflix.genie.common.dto.JobStatus var2, @NotBlank(message="Status message cannot be empty.") @NotBlank(message="Status message cannot be empty.") String var3) throws GenieException;

    public void setJobRunningInformation(@NotBlank String var1, @Min(value=0L, message="Must be no lower than zero") @Min(value=0L, message="Must be no lower than zero") int var2, @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") long var3, @NotNull Instant var5) throws GenieException;

    public void setJobCompletionInformation(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, int var2, @NotNull(message="No job status entered.") @NotNull(message="No job status entered.") com.netflix.genie.common.dto.JobStatus var3, @NotBlank(message="Status message can't be blank. Unable to update") @NotBlank(message="Status message can't be blank. Unable to update") String var4, @Nullable Long var5, @Nullable Long var6) throws GenieException;

    public long deleteBatchOfJobsCreatedBeforeDate(@NotNull Instant var1, @Min(value=1L) @Min(value=1L) int var2, @Min(value=1L) @Min(value=1L) int var3);

    @Nonnull
    public String saveJobSubmission(@Valid JobSubmission var1) throws IdAlreadyExistsException, SaveAttachmentException;

    public Optional<com.netflix.genie.common.external.dtos.v4.JobRequest> getJobRequest(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1);

    public void saveResolvedJob(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1, @Valid ResolvedJob var2);

    public Optional<JobSpecification> getJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1);

    public void claimJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1, @Valid AgentClientMetadata var2);

    public void updateJobStatus(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1, @NotNull JobStatus var2, @NotNull JobStatus var3, @Nullable String var4);

    public boolean isV4(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1) throws GenieNotFoundException;

    public JobStatus getJobStatus(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1) throws GenieNotFoundException;

    public Optional<String> getJobArchiveLocation(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1) throws GenieNotFoundException;

    public FinishedJob getFinishedJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1) throws GenieNotFoundException, GenieInvalidStatusException;

    public boolean isApiJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1) throws GenieNotFoundException;
}

