/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieBadRequestException;
import com.netflix.genie.common.exceptions.GenieConflictException;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterMetadata;
import com.netflix.genie.common.external.dtos.v4.ClusterRequest;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.entities.projections.ClusterCommandsProjection;
import com.netflix.genie.web.data.entities.v4.EntityDtoConverters;
import com.netflix.genie.web.data.repositories.jpa.JpaApplicationRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaClusterRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCommandRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCriterionRepository;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaClusterSpecs;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaBaseService;
import com.netflix.genie.web.data.services.jpa.JpaFilePersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaTagPersistenceService;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieRuntimeException.class, ConstraintViolationException.class})
public class JpaClusterPersistenceServiceImpl
extends JpaBaseService
implements ClusterPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaClusterPersistenceServiceImpl.class);

    public JpaClusterPersistenceServiceImpl(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository, JpaCriterionRepository criterionRepository) {
        super(tagPersistenceService, filePersistenceService, applicationRepository, clusterRepository, commandRepository, criterionRepository);
    }

    @Override
    public String createCluster(@NotNull(message="No cluster request entered. Unable to create.") @Valid @NotNull(message="No cluster request entered. Unable to create.") @Valid ClusterRequest request) throws GenieException {
        log.debug("Called to create cluster with request {}", (Object)request);
        ClusterEntity clusterEntity = this.createClusterEntity(request);
        try {
            this.getClusterRepository().save(clusterEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieConflictException("A cluster with id " + clusterEntity.getUniqueId() + " already exists", (Throwable)e);
        }
        return clusterEntity.getUniqueId();
    }

    @Override
    @Transactional(readOnly=true)
    public Cluster getCluster(@NotBlank(message="No id entered. Unable to get.") @NotBlank(message="No id entered. Unable to get.") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return EntityDtoConverters.toV4ClusterDto(this.findCluster(id));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Cluster> getClusters(@Nullable String name, @Nullable Set<ClusterStatus> statuses, @Nullable Set<String> tags, @Nullable Instant minUpdateTime, @Nullable Instant maxUpdateTime, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("called");
        if (tags != null) {
            tagEntities = this.getTagPersistenceService().getTags(tags);
            if (tagEntities.size() != tags.size()) {
                return new PageImpl(new ArrayList(), page, 0L);
            }
        } else {
            tagEntities = null;
        }
        Page clusterEntities = this.getClusterRepository().findAll(JpaClusterSpecs.find(name, statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null, tagEntities, minUpdateTime, maxUpdateTime), page);
        return clusterEntities.map(EntityDtoConverters::toV4ClusterDto);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Cluster, String> findClustersAndCommandsForJob(@NotNull(message="JobRequest object is null. Unable to continue.") @NotNull(message="JobRequest object is null. Unable to continue.") JobRequest jobRequest) throws GenieException {
        log.debug("Called");
        ArrayList clusterCriteria = Lists.newArrayList();
        for (ClusterCriteria criteria : jobRequest.getClusterCriterias()) {
            clusterCriteria.add(DtoConverters.toV4Criterion((ClusterCriteria)criteria));
        }
        Criterion commandCriterion = DtoConverters.toV4Criterion((Set)jobRequest.getCommandCriteria());
        return this.findClustersAndCommandsForJob(clusterCriteria, commandCriterion);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<Cluster, String> findClustersAndCommandsForCriteria(@NotEmpty List<@NotNull Criterion> clusterCriteria, @NotNull Criterion commandCriterion) throws GenieException {
        log.debug("Attempting to find cluster and commands for cluster criteria {} and command criterion {}", clusterCriteria, (Object)commandCriterion);
        return this.findClustersAndCommandsForJob(clusterCriteria, commandCriterion);
    }

    @Override
    public void updateCluster(@NotBlank(message="No cluster id entered. Unable to update.") @NotBlank(message="No cluster id entered. Unable to update.") String id, @NotNull(message="No cluster information entered. Unable to update.") @Valid @NotNull(message="No cluster information entered. Unable to update.") @Valid Cluster updateCluster) throws GenieException {
        log.debug("Called with id {} and cluster {}", (Object)id, (Object)updateCluster);
        if (!this.getClusterRepository().existsByUniqueId(id)) {
            throw new GenieNotFoundException("No cluster exists with the given id. Unable to update.");
        }
        String updateId = updateCluster.getId();
        if (!id.equals(updateId)) {
            throw new GenieBadRequestException("Cluster id inconsistent with id passed in.");
        }
        this.updateEntityWithDtoContents(this.findCluster(id), updateCluster);
    }

    @Override
    public void patchCluster(@NotBlank String id, @NotNull JsonPatch patch) throws GenieException {
        ClusterEntity clusterEntity = this.findCluster(id);
        try {
            Cluster clusterToPatch = EntityDtoConverters.toV4ClusterDto(clusterEntity);
            log.debug("Will patch cluster {}. Original state: {}", (Object)id, (Object)clusterToPatch);
            JsonNode clusterNode = GenieObjectMapper.getMapper().valueToTree((Object)clusterToPatch);
            JsonNode postPatchNode = patch.apply(clusterNode);
            Cluster patchedCluster = (Cluster)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, Cluster.class);
            log.debug("Finished patching cluster {}. New state: {}", (Object)id, (Object)patchedCluster);
            this.updateEntityWithDtoContents(clusterEntity, patchedCluster);
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch cluster {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void deleteAllClusters() throws GenieException {
        log.debug("Called to delete all clusters");
        for (ClusterEntity clusterEntity : this.getClusterRepository().findAll()) {
            this.deleteCluster(clusterEntity.getUniqueId());
        }
    }

    @Override
    public void deleteCluster(@NotBlank(message="No id entered unable to delete.") @NotBlank(message="No id entered unable to delete.") String id) throws GenieException {
        log.debug("Called");
        ClusterEntity clusterEntity = this.findCluster(id);
        List<CommandEntity> commandEntities = clusterEntity.getCommands();
        if (commandEntities != null) {
            for (CommandEntity commandEntity : commandEntities) {
                Set<ClusterEntity> clusterEntities = commandEntity.getClusters();
                if (clusterEntities == null) continue;
                clusterEntities.remove(clusterEntity);
            }
        }
        this.getClusterRepository().delete(clusterEntity);
    }

    @Override
    public void addConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to add configurations.") @NotBlank(message="No cluster id entered. Unable to add configurations.") String id, @NotEmpty(message="No configuration files entered. Unable to add.") @NotEmpty(message="No configuration files entered. Unable to add.") Set<String> configs) throws GenieException {
        log.debug("called");
        this.findCluster(id).getConfigs().addAll(this.createAndGetFileEntities(configs));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getConfigsForCluster(@NotBlank(message="No cluster id sent. Cannot retrieve configurations.") @NotBlank(message="No cluster id sent. Cannot retrieve configurations.") String id) throws GenieException {
        log.debug("called");
        return this.findCluster(id).getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to update configurations.") @NotBlank(message="No cluster id entered. Unable to update configurations.") String id, @NotEmpty(message="No configs entered. Unable to update.") @NotEmpty(message="No configs entered. Unable to update.") Set<String> configs) throws GenieException {
        log.debug("called with id {} and configs {}", (Object)id, configs);
        this.findCluster(id).setConfigs(this.createAndGetFileEntities(configs));
    }

    @Override
    public void removeAllConfigsForCluster(@NotBlank(message="No cluster id entered. Unable to remove configs.") @NotBlank(message="No cluster id entered. Unable to remove configs.") String id) throws GenieException {
        this.findCluster(id).getConfigs().clear();
    }

    @Override
    public void addDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to add dependencies.") @NotBlank(message="No cluster id entered. Unable to add dependencies.") String id, @NotEmpty(message="No dependencies entered. Unable to add dependencies.") @NotEmpty(message="No dependencies entered. Unable to add dependencies.") Set<String> dependencies) throws GenieException {
        this.findCluster(id).getDependencies().addAll(this.createAndGetFileEntities(dependencies));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to get dependencies.") @NotBlank(message="No cluster id entered. Unable to get dependencies.") String id) throws GenieException {
        return this.findCluster(id).getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public void updateDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to update dependencies.") @NotBlank(message="No cluster id entered. Unable to update dependencies.") String id, @NotNull(message="No dependencies entered. Unable to update.") @NotNull(message="No dependencies entered. Unable to update.") Set<String> dependencies) throws GenieException {
        this.findCluster(id).setDependencies(this.createAndGetFileEntities(dependencies));
    }

    @Override
    public void removeAllDependenciesForCluster(@NotBlank(message="No cluster id entered. Unable to remove dependencies.") @NotBlank(message="No cluster id entered. Unable to remove dependencies.") String id) throws GenieException {
        this.findCluster(id).getDependencies().clear();
    }

    @Override
    public void removeDependencyForCluster(@NotBlank(message="No cluster id entered. Unable to remove dependency.") @NotBlank(message="No cluster id entered. Unable to remove dependency.") String id, @NotBlank(message="No dependency entered. Unable to remove dependency.") @NotBlank(message="No dependency entered. Unable to remove dependency.") String dependency) throws GenieException {
        this.getFilePersistenceService().getFile(dependency).ifPresent(this.findCluster(id).getDependencies()::remove);
    }

    @Override
    public void addTagsForCluster(@NotBlank(message="No cluster id entered. Unable to add tags.") @NotBlank(message="No cluster id entered. Unable to add tags.") String id, @NotEmpty(message="No tags entered. Unable to add to tags.") @NotEmpty(message="No tags entered. Unable to add to tags.") Set<String> tags) throws GenieException {
        this.findCluster(id).getTags().addAll(this.createAndGetTagEntities(tags));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getTagsForCluster(@NotBlank(message="No cluster id sent. Cannot retrieve tags.") @NotBlank(message="No cluster id sent. Cannot retrieve tags.") String id) throws GenieException {
        return this.findCluster(id).getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet());
    }

    @Override
    public void updateTagsForCluster(@NotBlank(message="No cluster id entered. Unable to update tags.") @NotBlank(message="No cluster id entered. Unable to update tags.") String id, @NotEmpty(message="No tags entered. Unable to update.") @NotEmpty(message="No tags entered. Unable to update.") Set<String> tags) throws GenieException {
        this.findCluster(id).setTags(this.createAndGetTagEntities(tags));
    }

    @Override
    public void removeAllTagsForCluster(@NotBlank(message="No cluster id entered. Unable to remove tags.") @NotBlank(message="No cluster id entered. Unable to remove tags.") String id) throws GenieException {
        this.findCluster(id).getTags().clear();
    }

    @Override
    public void removeTagForCluster(@NotBlank(message="No cluster id entered. Unable to remove tag.") @NotBlank(message="No cluster id entered. Unable to remove tag.") String id, @NotBlank(message="No tag entered. Unable to remove.") @NotBlank(message="No tag entered. Unable to remove.") String tag) throws GenieException {
        this.getTagPersistenceService().getTag(tag).ifPresent(this.findCluster(id).getTags()::remove);
    }

    @Override
    public void addCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to add commands.") @NotBlank(message="No cluster id entered. Unable to add commands.") String id, @NotEmpty(message="No command ids entered. Unable to add commands.") @NotEmpty(message="No command ids entered. Unable to add commands.") List<String> commandIds) throws GenieException {
        if ((long)commandIds.size() != commandIds.stream().filter(this.getCommandRepository()::existsByUniqueId).count()) {
            throw new GeniePreconditionException("All commands need to exist to add to a cluster");
        }
        ClusterEntity clusterEntity = this.findCluster(id);
        for (String commandId : commandIds) {
            clusterEntity.addCommand(this.getCommandEntity(commandId).orElseThrow(() -> new GenieNotFoundException("Couldn't find command with unique id " + commandId)));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Command> getCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to get commands.") @NotBlank(message="No cluster id entered. Unable to get commands.") String id, @Nullable Set<CommandStatus> statuses) throws GenieException {
        Optional<ClusterCommandsProjection> commandsProjection = this.getClusterRepository().findByUniqueId(id, ClusterCommandsProjection.class);
        List<CommandEntity> commandEntities = commandsProjection.orElseThrow(() -> new GenieNotFoundException("No cluster with id " + id + " exists")).getCommands();
        if (statuses != null) {
            HashSet notNullStatuses = Sets.newHashSet(statuses);
            return commandEntities.stream().filter(command -> notNullStatuses.contains(DtoConverters.toV4CommandStatus((String)command.getStatus()))).map(EntityDtoConverters::toV4CommandDto).collect(Collectors.toList());
        }
        return commandEntities.stream().map(EntityDtoConverters::toV4CommandDto).collect(Collectors.toList());
    }

    @Override
    public void setCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to update commands.") @NotBlank(message="No cluster id entered. Unable to update commands.") String id, @NotNull(message="No command ids entered. Unable to update commands.") @NotNull(message="No command ids entered. Unable to update commands.") List<String> commandIds) throws GenieException {
        if ((long)commandIds.size() != commandIds.stream().filter(this.getCommandRepository()::existsByUniqueId).count()) {
            throw new GeniePreconditionException("All commands need to exist to add to a cluster");
        }
        ClusterEntity clusterEntity = this.findCluster(id);
        ArrayList<CommandEntity> commandEntities = new ArrayList<CommandEntity>();
        for (String commandId : commandIds) {
            commandEntities.add(this.getCommandEntity(commandId).orElseThrow(() -> new GenieNotFoundException("Couldn't find command with unique id " + commandId)));
        }
        clusterEntity.setCommands(commandEntities);
    }

    @Override
    public void removeAllCommandsForCluster(@NotBlank(message="No cluster id entered. Unable to remove commands.") @NotBlank(message="No cluster id entered. Unable to remove commands.") String id) throws GenieException {
        this.findCluster(id).removeAllCommands();
    }

    @Override
    public void removeCommandForCluster(@NotBlank(message="No cluster id entered. Unable to remove command.") @NotBlank(message="No cluster id entered. Unable to remove command.") String id, @NotBlank(message="No command id entered. Unable to remove command.") @NotBlank(message="No command id entered. Unable to remove command.") String cmdId) throws GenieException {
        this.findCluster(id).removeCommand(this.getCommandEntity(cmdId).orElseThrow(() -> new GenieNotFoundException("No command with id " + cmdId + " exists.")));
    }

    @Override
    public long deleteTerminatedClusters() {
        return this.getClusterRepository().deleteByIdIn(this.getClusterRepository().findTerminatedUnusedClusters().stream().map(Number::longValue).collect(Collectors.toSet()));
    }

    private ClusterEntity createClusterEntity(ClusterRequest request) {
        ExecutionEnvironment resources = request.getResources();
        ClusterMetadata metadata = request.getMetadata();
        ClusterEntity entity = new ClusterEntity();
        this.setUniqueId(entity, request.getRequestedId().orElse(null));
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityClusterMetadata(entity, metadata);
        return entity;
    }

    private void updateEntityWithDtoContents(ClusterEntity entity, Cluster dto) {
        ExecutionEnvironment resources = dto.getResources();
        ClusterMetadata metadata = dto.getMetadata();
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies, entity::setSetupFile);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setEntityClusterMetadata(entity, metadata);
    }

    private void setEntityClusterMetadata(ClusterEntity entity, ClusterMetadata metadata) {
        entity.setName(metadata.getName());
        entity.setUser(metadata.getUser());
        entity.setVersion(metadata.getVersion());
        entity.setDescription(metadata.getDescription().orElse(null));
        entity.setStatus(metadata.getStatus().name());
        EntityDtoConverters.setJsonField(metadata.getMetadata().orElse(null), entity::setMetadata);
    }

    private Map<Cluster, String> findClustersAndCommandsForJob(List<Criterion> clusterCriteria, Criterion commandCriterion) throws GenieServerException {
        HashMap foundClusters = Maps.newHashMap();
        for (Criterion clusterCriterion : clusterCriteria) {
            List clusterCommands = this.getClusterRepository().resolveClustersAndCommands(clusterCriterion, commandCriterion);
            if (clusterCommands.isEmpty()) continue;
            for (Object[] ids : clusterCommands) {
                if (ids.length != 2) {
                    throw new GenieServerException("Expected result length 2 but got " + ids.length);
                }
                if (!(ids[0] instanceof Number)) {
                    throw new GenieServerException("Expected number type but got " + ids[0].getClass().getName());
                }
                long clusterId = ((Number)ids[0]).longValue();
                if (!(ids[1] instanceof String)) {
                    throw new GenieServerException("Expected String type but got " + ids[1].getClass().getName());
                }
                String commandUniqueId = (String)ids[1];
                ClusterEntity clusterEntity = (ClusterEntity)this.getClusterRepository().getOne(clusterId);
                foundClusters.put(EntityDtoConverters.toV4ClusterDto(clusterEntity), commandUniqueId);
            }
            return foundClusters;
        }
        return foundClusters;
    }

    private ClusterEntity findCluster(String id) throws GenieNotFoundException {
        return (ClusterEntity)this.getClusterRepository().findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No cluster with id " + id + " exists."));
    }
}

