/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieConflictException;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.AgentConfigRequest;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.dtos.v4.ExecutionResourceCriteria;
import com.netflix.genie.common.external.dtos.v4.JobArchivalDataRequest;
import com.netflix.genie.common.external.dtos.v4.JobEnvironment;
import com.netflix.genie.common.external.dtos.v4.JobEnvironmentRequest;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.v4.FinishedJob;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieApplicationNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobAlreadyClaimedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.entities.ApplicationEntity;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.CriterionEntity;
import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.JobEntity;
import com.netflix.genie.web.data.entities.projections.IdProjection;
import com.netflix.genie.web.data.entities.projections.JobApiProjection;
import com.netflix.genie.web.data.entities.projections.JobArchiveLocationProjection;
import com.netflix.genie.web.data.entities.projections.StatusProjection;
import com.netflix.genie.web.data.entities.projections.v4.FinishedJobProjection;
import com.netflix.genie.web.data.entities.projections.v4.IsV4JobProjection;
import com.netflix.genie.web.data.entities.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.data.entities.projections.v4.V4JobRequestProjection;
import com.netflix.genie.web.data.entities.v4.EntityDtoConverters;
import com.netflix.genie.web.data.repositories.jpa.JpaApplicationRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaClusterRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCommandRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCriterionRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaJobRepository;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaBaseService;
import com.netflix.genie.web.data.services.jpa.JpaFilePersistenceService;
import com.netflix.genie.web.data.services.jpa.JpaServiceUtils;
import com.netflix.genie.web.data.services.jpa.JpaTagPersistenceService;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.SaveAttachmentException;
import com.netflix.genie.web.services.AttachmentService;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieRuntimeException.class, ConstraintViolationException.class, IdAlreadyExistsException.class, SaveAttachmentException.class})
public class JpaJobPersistenceServiceImpl
extends JpaBaseService
implements JobPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaJobPersistenceServiceImpl.class);
    private final JpaJobRepository jobRepository;
    private final AttachmentService attachmentService;

    public JpaJobPersistenceServiceImpl(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository, JpaCriterionRepository criterionRepository, JpaJobRepository jobRepository, AttachmentService attachmentService) {
        super(tagPersistenceService, filePersistenceService, applicationRepository, clusterRepository, commandRepository, criterionRepository);
        this.jobRepository = jobRepository;
        this.attachmentService = attachmentService;
    }

    @Override
    public void createJob(@NotNull JobRequest jobRequest, @NotNull JobMetadata jobMetadata, @NotNull Job job, @NotNull JobExecution jobExecution) throws GenieException {
        log.debug("Called with\nRequest:\n{}\nMetadata:\n{}\nJob:\n{}\nExecution:\n{}\n", new Object[]{jobRequest, jobMetadata, job, jobExecution});
        String jobId = (String)jobRequest.getId().orElseThrow(() -> new GeniePreconditionException("No job id entered"));
        JobEntity jobEntity = this.toEntity(jobId, jobRequest, jobMetadata, job, jobExecution);
        try {
            this.jobRepository.save(jobEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieConflictException("A job with id " + jobId + " already exists", (Throwable)e);
        }
    }

    @Override
    public void updateJobWithRuntimeEnvironment(@NotBlank String jobId, @NotBlank String clusterId, @NotBlank String commandId, @NotNull List<String> applicationIds, @Min(value=1L) @Min(value=1L) int memory) throws GenieException {
        log.debug("Called to update job ({}) runtime with cluster {}, command {} and applications {}", new Object[]{jobId, clusterId, commandId, applicationIds});
        JobEntity job = (JobEntity)this.jobRepository.findByUniqueId(jobId).orElseThrow(() -> new GenieNotFoundException("No job with id " + jobId + " exists."));
        try {
            this.setExecutionResources(job, clusterId, commandId, applicationIds);
        }
        catch (GenieApplicationNotFoundException | GenieClusterNotFoundException | GenieCommandNotFoundException e) {
            throw new GenieNotFoundException(e.getMessage(), e);
        }
        job.setMemoryUsed(memory);
        job.setResolved(true);
    }

    @Override
    public void updateJobStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") com.netflix.genie.common.dto.JobStatus jobStatus, @NotBlank(message="Status message cannot be empty.") @NotBlank(message="Status message cannot be empty.") String statusMsg) throws GenieException {
        log.debug("Called to update job with id {}, status {} and statusMsg \"{}\"", new Object[]{id, jobStatus, statusMsg});
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job exists for the id specified"));
        this.updateJobStatus(jobEntity, DtoConverters.toV4JobStatus((com.netflix.genie.common.dto.JobStatus)jobStatus), statusMsg);
    }

    @Override
    public void setJobRunningInformation(@NotBlank String id, @Min(value=0L, message="Must be no lower than zero") @Min(value=0L, message="Must be no lower than zero") int processId, @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") long checkDelay, @NotNull Instant timeout) throws GenieException {
        log.debug("Called with to update job {} with process id {}", (Object)id, (Object)processId);
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to update"));
        this.updateJobStatus(jobEntity, JobStatus.RUNNING, "Job is Running.");
        jobEntity.setProcessId(processId);
        jobEntity.setCheckDelay(checkDelay);
        jobEntity.getStarted().ifPresent(started -> jobEntity.setTimeoutUsed(this.toTimeoutUsed((Instant)started, timeout)));
    }

    @Override
    public void setJobCompletionInformation(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, int exitCode, @NotNull(message="No job status entered.") @NotNull(message="No job status entered.") com.netflix.genie.common.dto.JobStatus status, @NotBlank(message="Status message can't be blank. Unable to update") @NotBlank(message="Status message can't be blank. Unable to update") String statusMessage, @Nullable Long stdOutSize, @Nullable Long stdErrSize) throws GenieException {
        log.debug("Called with id: {}, exit code: {}, status: {}, status message: {}, std out size: {}, std err size {}", new Object[]{id, exitCode, status, statusMessage, stdOutSize, stdErrSize});
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists unable to update"));
        this.updateJobStatus(jobEntity, DtoConverters.toV4JobStatus((com.netflix.genie.common.dto.JobStatus)status), statusMessage);
        jobEntity.setExitCode(exitCode);
        jobEntity.setStdOutSize(stdOutSize);
        jobEntity.setStdErrSize(stdErrSize);
    }

    @Override
    public long deleteBatchOfJobsCreatedBeforeDate(@NotNull Instant date, @Min(value=1L) @Min(value=1L) int maxDeleted, @Min(value=1L) @Min(value=1L) int pageSize) {
        Slice<IdProjection> idProjections;
        log.info("Attempting to delete batch of jobs (at most {}) created before {} ms from epoch", (Object)maxDeleted, (Object)date.toEpochMilli());
        long jobsDeleted = 0L;
        long totalAttemptedDeletions = 0L;
        PageRequest page = PageRequest.of((int)0, (int)pageSize);
        do {
            if (!(idProjections = this.jobRepository.findByCreatedBefore(date, (Pageable)page)).hasContent()) continue;
            List<Long> ids = idProjections.getContent().stream().map(IdProjection::getId).collect(Collectors.toList());
            long toBeDeleted = ids.size();
            totalAttemptedDeletions += toBeDeleted;
            log.debug("Attempting to delete {} rows from jobs...", (Object)toBeDeleted);
            long deletedJobs = this.jobRepository.deleteByIdIn(ids);
            log.debug("Successfully deleted {} rows from jobs...", (Object)deletedJobs);
            if (deletedJobs != toBeDeleted) {
                log.error("Deleted {} job records but expected to delete {}", (Object)deletedJobs, (Object)toBeDeleted);
            }
            jobsDeleted += deletedJobs;
        } while (idProjections.hasNext() && totalAttemptedDeletions < (long)maxDeleted);
        log.info("Deleted a chunk of {} job records: {} job", (Object)totalAttemptedDeletions, (Object)jobsDeleted);
        return totalAttemptedDeletions;
    }

    @Override
    @Nonnull
    public String saveJobSubmission(@Valid JobSubmission jobSubmission) throws IdAlreadyExistsException, SaveAttachmentException {
        log.debug("Attempting to save job submission {}", (Object)jobSubmission);
        JobEntity jobEntity = new JobEntity();
        jobEntity.setStatus(JobStatus.RESERVED.name());
        com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest = jobSubmission.getJobRequest();
        JobRequestMetadata jobRequestMetadata = jobSubmission.getJobRequestMetadata();
        this.setUniqueId(jobEntity, jobRequest.getRequestedId().orElse(null));
        Set<URI> attachmentURIs = this.attachmentService.saveAttachments(jobEntity.getUniqueId(), jobSubmission.getAttachments());
        jobEntity.setCommandArgs(jobRequest.getCommandArgs());
        this.setJobMetadataFields(jobEntity, jobRequest.getMetadata());
        this.setExecutionEnvironmentFields(jobEntity, jobRequest.getResources(), attachmentURIs);
        this.setExecutionResourceCriteriaFields(jobEntity, jobRequest.getCriteria());
        this.setRequestedJobEnvironmentFields(jobEntity, jobRequest.getRequestedJobEnvironment());
        this.setRequestedAgentConfigFields(jobEntity, jobRequest.getRequestedAgentConfig());
        this.setRequestedJobArchivalData(jobEntity, jobRequest.getRequestedJobArchivalData());
        this.setRequestMetadataFields(jobEntity, jobRequestMetadata);
        jobEntity.setV4(true);
        try {
            String id = ((JobEntity)this.jobRepository.save(jobEntity)).getUniqueId();
            log.debug("Saved job submission {} under job id {}", (Object)jobSubmission, (Object)id);
            return id;
        }
        catch (DataIntegrityViolationException e) {
            throw new IdAlreadyExistsException("A job with id " + jobEntity.getUniqueId() + " already exists. Unable to reserve id.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<com.netflix.genie.common.external.dtos.v4.JobRequest> getJobRequest(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) {
        log.debug("Requested to get Job Request for id {}", (Object)id);
        return this.jobRepository.findByUniqueId(id, V4JobRequestProjection.class).map(EntityDtoConverters::toV4JobRequestDto);
    }

    @Override
    public void saveResolvedJob(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id, @Valid ResolvedJob resolvedJob) {
        log.debug("Requested to save resolved information {} for job with id {}", (Object)resolvedJob, (Object)id);
        JobEntity entity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> {
            String error = "No job found with id " + id + ". Unable to save job specification";
            log.error(error);
            return new GenieJobNotFoundException(error);
        });
        try {
            if (entity.isResolved()) {
                log.error("Attempted to save resolved job information {} for job {} that was already resolved", (Object)resolvedJob, (Object)id);
                return;
            }
            if (!DtoConverters.toV4JobStatus((String)entity.getStatus()).isResolvable()) {
                log.error("Job {} is already in a non-resolvable state {}. Needs to be one of {}. Won't save resolved info", new Object[]{id, entity.getStatus(), JobStatus.getResolvableStatuses()});
                return;
            }
            JobSpecification jobSpecification = resolvedJob.getJobSpecification();
            this.setExecutionResources(entity, jobSpecification.getCluster().getId(), jobSpecification.getCommand().getId(), jobSpecification.getApplications().stream().map(JobSpecification.ExecutionResource::getId).collect(Collectors.toList()));
            entity.setEnvironmentVariables(jobSpecification.getEnvironmentVariables());
            entity.setJobDirectoryLocation(jobSpecification.getJobDirectoryLocation().getAbsolutePath());
            jobSpecification.getArchiveLocation().ifPresent(entity::setArchiveLocation);
            jobSpecification.getTimeout().ifPresent(entity::setTimeoutUsed);
            JobEnvironment jobEnvironment = resolvedJob.getJobEnvironment();
            entity.setMemoryUsed(jobEnvironment.getMemory());
            entity.setResolved(true);
            entity.setStatus(JobStatus.RESOLVED.name());
            log.debug("Saved resolved information {} for job with id {}", (Object)resolvedJob, (Object)id);
        }
        catch (GenieApplicationNotFoundException | GenieClusterNotFoundException | GenieCommandNotFoundException e) {
            log.error("Unable to save resolved job information {} for job {} due to {}", new Object[]{resolvedJob, id, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<JobSpecification> getJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) {
        log.debug("Requested to get job specification for job {}", (Object)id);
        JobSpecificationProjection projection = this.jobRepository.findByUniqueId(id, JobSpecificationProjection.class).orElseThrow(() -> {
            String errorMessage = "No job ith id " + id + "exists. Unable to get job specification.";
            log.error(errorMessage);
            return new GenieJobNotFoundException(errorMessage);
        });
        return projection.isResolved() ? Optional.of(EntityDtoConverters.toJobSpecificationDto(projection)) : Optional.empty();
    }

    @Override
    public void claimJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id, @Valid AgentClientMetadata agentClientMetadata) {
        log.debug("Agent with metadata {} requesting to claim job with id {}", (Object)agentClientMetadata, (Object)id);
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists. Unable to claim."));
        if (jobEntity.isClaimed()) {
            throw new GenieJobAlreadyClaimedException("Job with id " + id + " is already claimed. Unable to claim.");
        }
        JobStatus currentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (!currentStatus.isClaimable()) {
            throw new GenieInvalidStatusException("Job " + id + " is in status " + currentStatus + " and can't be claimed. Needs to be one of " + JobStatus.getClaimableStatuses());
        }
        jobEntity.setClaimed(true);
        jobEntity.setStatus(JobStatus.CLAIMED.name());
        agentClientMetadata.getHostname().ifPresent(jobEntity::setAgentHostname);
        agentClientMetadata.getVersion().ifPresent(jobEntity::setAgentVersion);
        agentClientMetadata.getPid().ifPresent(jobEntity::setAgentPid);
        log.debug("Claimed job {} for agent with metadata {}", (Object)id, (Object)agentClientMetadata);
    }

    @Override
    public void updateJobStatus(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id, @NotNull JobStatus currentStatus, @NotNull JobStatus newStatus, @Nullable String newStatusMessage) {
        log.debug("Requested to change the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
        if (currentStatus == newStatus) {
            throw new GenieInvalidStatusException("Can't update the status of job " + id + " because both current and new status are " + currentStatus);
        }
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists. Unable to update status."));
        JobStatus actualCurrentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (actualCurrentStatus != currentStatus) {
            throw new GenieInvalidStatusException("Job " + id + " current status is " + actualCurrentStatus + " but API caller expected it to be " + currentStatus + ". Unable to update status due to inconsistent state.");
        }
        this.updateJobStatus(jobEntity, newStatus, newStatusMessage);
        log.debug("Changed the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isV4(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) throws GenieNotFoundException {
        log.debug("Read v4 flag from db for job {} ", (Object)id);
        return this.jobRepository.findByUniqueId(id, IsV4JobProjection.class).orElseThrow(() -> {
            String errorMessage = "No job with id " + id + " exists. Unable to get v4 flag.";
            log.error(errorMessage);
            return new GenieNotFoundException(errorMessage);
        }).isV4();
    }

    @Override
    @Transactional(readOnly=true)
    public JobStatus getJobStatus(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id) throws GenieNotFoundException {
        return DtoConverters.toV4JobStatus((String)this.jobRepository.findByUniqueId(id, StatusProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to get status.")).getStatus());
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<String> getJobArchiveLocation(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id) throws GenieNotFoundException {
        return this.jobRepository.findByUniqueId(id, JobArchiveLocationProjection.class).map(JobArchiveLocationProjection::getArchiveLocation).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exits."));
    }

    @Override
    @Transactional(readOnly=true)
    public FinishedJob getFinishedJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id) throws GenieNotFoundException, GenieInvalidStatusException {
        return this.jobRepository.findByUniqueId(id, FinishedJobProjection.class).map(EntityDtoConverters::toFinishedJobDto).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists."));
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isApiJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id) throws GenieNotFoundException {
        return this.jobRepository.findByUniqueId(id, JobApiProjection.class).map(JobApiProjection::isApi).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists"));
    }

    private void updateJobStatus(JobEntity jobEntity, JobStatus newStatus, @Nullable String statusMsg) {
        JobStatus currentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (currentStatus.isActive()) {
            jobEntity.setStatus(newStatus.name());
            jobEntity.setStatusMsg(statusMsg);
            if (newStatus.equals((Object)JobStatus.RUNNING)) {
                jobEntity.setStarted(Instant.now());
            } else if (jobEntity.getStarted().isPresent() && newStatus.isFinished()) {
                jobEntity.setFinished(Instant.now());
            }
        }
    }

    private JobEntity toEntity(String id, JobRequest jobRequest, JobMetadata jobMetadata, Job job, JobExecution jobExecution) {
        FileEntity setupFile;
        JobEntity jobEntity = new JobEntity();
        jobEntity.setUniqueId(id);
        jobEntity.setName(jobRequest.getName());
        jobEntity.setUser(jobRequest.getUser());
        jobEntity.setVersion(jobRequest.getVersion());
        jobEntity.setStatus(JobStatus.INIT.name());
        jobRequest.getDescription().ifPresent(jobEntity::setDescription);
        jobRequest.getMetadata().ifPresent(metadata -> EntityDtoConverters.setJsonField(metadata, jobEntity::setMetadata));
        JpaServiceUtils.setEntityMetadata(GenieObjectMapper.getMapper(), jobRequest, jobEntity);
        jobRequest.getCommandArgs().ifPresent(commandArgs -> jobEntity.setCommandArgs(Lists.newArrayList((Object[])new String[]{commandArgs})));
        jobRequest.getGroup().ifPresent(jobEntity::setGenieUserGroup);
        FileEntity fileEntity = setupFile = jobRequest.getSetupFile().isPresent() ? this.createAndGetFileEntity((String)jobRequest.getSetupFile().get()) : null;
        if (setupFile != null) {
            jobEntity.setSetupFile(setupFile);
        }
        ArrayList clusterCriteria = Lists.newArrayListWithExpectedSize((int)jobRequest.getClusterCriterias().size());
        for (ClusterCriteria clusterCriterion : jobRequest.getClusterCriterias()) {
            clusterCriteria.add(new CriterionEntity(null, null, null, null, this.createAndGetTagEntities(clusterCriterion.getTags())));
        }
        jobEntity.setClusterCriteria(clusterCriteria);
        jobEntity.setCommandCriterion(new CriterionEntity(null, null, null, null, this.createAndGetTagEntities(jobRequest.getCommandCriteria())));
        jobEntity.setConfigs(this.createAndGetFileEntities(jobRequest.getConfigs()));
        jobEntity.setDependencies(this.createAndGetFileEntities(jobRequest.getDependencies()));
        jobEntity.setArchivingDisabled(jobRequest.isDisableLogArchival());
        jobRequest.getEmail().ifPresent(jobEntity::setEmail);
        if (!jobRequest.getTags().isEmpty()) {
            jobEntity.setTags(this.createAndGetTagEntities(jobRequest.getTags()));
        }
        jobRequest.getCpu().ifPresent(jobEntity::setRequestedCpu);
        jobRequest.getMemory().ifPresent(jobEntity::setRequestedMemory);
        if (!jobRequest.getApplications().isEmpty()) {
            jobEntity.setRequestedApplications(jobRequest.getApplications());
        }
        jobRequest.getTimeout().ifPresent(jobEntity::setRequestedTimeout);
        jobRequest.getGrouping().ifPresent(jobEntity::setGrouping);
        jobRequest.getGroupingInstance().ifPresent(jobEntity::setGroupingInstance);
        jobMetadata.getClientHost().ifPresent(jobEntity::setRequestApiClientHostname);
        jobMetadata.getUserAgent().ifPresent(jobEntity::setRequestApiClientUserAgent);
        jobMetadata.getNumAttachments().ifPresent(jobEntity::setNumAttachments);
        jobMetadata.getTotalSizeOfAttachments().ifPresent(jobEntity::setTotalSizeOfAttachments);
        jobMetadata.getStdErrSize().ifPresent(jobEntity::setStdErrSize);
        jobMetadata.getStdOutSize().ifPresent(jobEntity::setStdOutSize);
        jobEntity.setApi(true);
        job.getArchiveLocation().ifPresent(jobEntity::setArchiveLocation);
        job.getStarted().ifPresent(jobEntity::setStarted);
        job.getFinished().ifPresent(jobEntity::setFinished);
        jobEntity.setStatus(job.getStatus().name());
        job.getStatusMsg().ifPresent(jobEntity::setStatusMsg);
        jobEntity.setAgentHostname(jobExecution.getHostName());
        jobExecution.getProcessId().ifPresent(jobEntity::setProcessId);
        jobExecution.getCheckDelay().ifPresent(jobEntity::setCheckDelay);
        if (job.getStarted().isPresent() && jobExecution.getTimeout().isPresent()) {
            jobEntity.setTimeoutUsed(this.toTimeoutUsed((Instant)job.getStarted().get(), (Instant)jobExecution.getTimeout().get()));
        }
        jobExecution.getMemory().ifPresent(jobEntity::setMemoryUsed);
        jobEntity.setV4(false);
        return jobEntity;
    }

    private void setJobMetadataFields(JobEntity jobEntity, com.netflix.genie.common.external.dtos.v4.JobMetadata jobMetadata) {
        jobEntity.setName(jobMetadata.getName());
        jobEntity.setUser(jobMetadata.getUser());
        jobEntity.setVersion(jobMetadata.getVersion());
        jobEntity.setTags(this.createAndGetTagEntities(jobMetadata.getTags()));
        Optional jsonMetadata = jobMetadata.getMetadata();
        jsonMetadata.ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setMetadata));
        jobMetadata.getDescription().ifPresent(jobEntity::setDescription);
        jobMetadata.getEmail().ifPresent(jobEntity::setEmail);
        jobMetadata.getGroup().ifPresent(jobEntity::setGenieUserGroup);
        jobMetadata.getGrouping().ifPresent(jobEntity::setGrouping);
        jobMetadata.getGroupingInstance().ifPresent(jobEntity::setGroupingInstance);
    }

    private void setExecutionEnvironmentFields(JobEntity jobEntity, ExecutionEnvironment executionEnvironment, @Nullable Set<URI> savedAttachments) {
        FileEntity setupFile;
        FileEntity fileEntity = setupFile = executionEnvironment.getSetupFile().isPresent() ? this.createAndGetFileEntity((String)executionEnvironment.getSetupFile().get()) : null;
        if (setupFile != null) {
            jobEntity.setSetupFile(setupFile);
        }
        jobEntity.setConfigs(this.createAndGetFileEntities(executionEnvironment.getConfigs()));
        Set<FileEntity> dependencies = this.createAndGetFileEntities(executionEnvironment.getDependencies());
        if (savedAttachments != null) {
            dependencies.addAll(this.createAndGetFileEntities(savedAttachments.stream().map(URI::toString).collect(Collectors.toSet())));
        }
        jobEntity.setDependencies(dependencies);
    }

    private void setExecutionResourceCriteriaFields(JobEntity jobEntity, ExecutionResourceCriteria criteria) {
        List clusterCriteria = criteria.getClusterCriteria();
        ArrayList clusterCriteriaEntities = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (Criterion clusterCriterion : clusterCriteria) {
            clusterCriteriaEntities.add(this.toCriterionEntity(clusterCriterion));
        }
        jobEntity.setClusterCriteria(clusterCriteriaEntities);
        jobEntity.setCommandCriterion(this.toCriterionEntity(criteria.getCommandCriterion()));
        jobEntity.setRequestedApplications(criteria.getApplicationIds());
    }

    private void setRequestedJobEnvironmentFields(JobEntity jobEntity, JobEnvironmentRequest requestedJobEnvironment) {
        jobEntity.setRequestedEnvironmentVariables(requestedJobEnvironment.getRequestedEnvironmentVariables());
        requestedJobEnvironment.getRequestedJobMemory().ifPresent(jobEntity::setRequestedMemory);
        requestedJobEnvironment.getRequestedJobCpu().ifPresent(jobEntity::setRequestedCpu);
        Optional agentEnvironmentExt = requestedJobEnvironment.getExt();
        agentEnvironmentExt.ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setRequestedAgentEnvironmentExt));
    }

    private void setRequestedAgentConfigFields(JobEntity jobEntity, AgentConfigRequest requestedAgentConfig) {
        jobEntity.setInteractive(requestedAgentConfig.isInteractive());
        jobEntity.setArchivingDisabled(requestedAgentConfig.isArchivingDisabled());
        requestedAgentConfig.getRequestedJobDirectoryLocation().ifPresent(location -> jobEntity.setRequestedJobDirectoryLocation(location.getAbsolutePath()));
        requestedAgentConfig.getTimeoutRequested().ifPresent(jobEntity::setRequestedTimeout);
        requestedAgentConfig.getExt().ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setRequestedAgentConfigExt));
    }

    private void setRequestedJobArchivalData(JobEntity jobEntity, JobArchivalDataRequest requestedjobArchivalData) {
        requestedjobArchivalData.getRequestedArchiveLocationPrefix().ifPresent(jobEntity::setRequestedArchiveLocationPrefix);
    }

    private void setRequestMetadataFields(JobEntity jobEntity, JobRequestMetadata jobRequestMetadata) {
        jobEntity.setApi(jobRequestMetadata.isApi());
        jobEntity.setNumAttachments(jobRequestMetadata.getNumAttachments());
        jobEntity.setTotalSizeOfAttachments(jobRequestMetadata.getTotalSizeOfAttachments());
        jobRequestMetadata.getApiClientMetadata().ifPresent(apiClientMetadata -> {
            apiClientMetadata.getHostname().ifPresent(jobEntity::setRequestApiClientHostname);
            apiClientMetadata.getUserAgent().ifPresent(jobEntity::setRequestApiClientUserAgent);
        });
        jobRequestMetadata.getAgentClientMetadata().ifPresent(agentClientMetadata -> {
            agentClientMetadata.getHostname().ifPresent(jobEntity::setRequestAgentClientHostname);
            agentClientMetadata.getVersion().ifPresent(jobEntity::setRequestAgentClientVersion);
            agentClientMetadata.getPid().ifPresent(jobEntity::setRequestAgentClientPid);
        });
    }

    private void setExecutionResources(JobEntity job, String clusterId, String commandId, List<String> applicationIds) {
        ClusterEntity cluster = this.getClusterEntity(clusterId).orElseThrow(() -> new GenieClusterNotFoundException("Cannot find cluster with ID " + clusterId));
        CommandEntity command = this.getCommandEntity(commandId).orElseThrow(() -> new GenieCommandNotFoundException("Cannot find command with ID " + commandId));
        ArrayList applications = Lists.newArrayList();
        for (String applicationId : applicationIds) {
            ApplicationEntity application = this.getApplicationEntity(applicationId).orElseThrow(() -> new GenieApplicationNotFoundException("Cannot find application with ID + " + applicationId));
            applications.add(application);
        }
        job.setCluster(cluster);
        job.setCommand(command);
        job.setApplications(applications);
    }

    private int toTimeoutUsed(Instant started, Instant timeout) {
        return (int)started.until(timeout, ChronoUnit.SECONDS);
    }
}

