/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobExecutionEnvironment {
    private static final Logger log = LoggerFactory.getLogger(JobExecutionEnvironment.class);
    private final JobRequest jobRequest;
    private final Cluster cluster;
    private final Command command;
    private final List<Application> applications = new ArrayList<Application>();
    private final int memory;
    private final File jobWorkingDir;

    private JobExecutionEnvironment(Builder builder) {
        this.jobRequest = builder.bJobRequest;
        this.cluster = builder.bCluster;
        this.command = builder.bCommand;
        this.applications.addAll(builder.bApplications);
        this.memory = builder.bMemory;
        this.jobWorkingDir = builder.bJobWorkingDir;
    }

    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public JobRequest getJobRequest() {
        return this.jobRequest;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getMemory() {
        return this.memory;
    }

    public File getJobWorkingDir() {
        return this.jobWorkingDir;
    }

    public static class Builder {
        private final JobRequest bJobRequest;
        private final Cluster bCluster;
        private final Command bCommand;
        private final List<Application> bApplications = new ArrayList<Application>();
        private final int bMemory;
        private final File bJobWorkingDir;

        public Builder(@NotNull(message="Job Request cannot be null") @NotNull(message="Job Request cannot be null") JobRequest request, @NotNull(message="Cluster cannot be null") @NotNull(message="Cluster cannot be null") Cluster clusterObj, @NotNull(message="Command cannot be null") @NotNull(message="Command cannot be null") Command commandObj, @Min(value=1L, message="Amount of memory can't be less than 1 MB") @Min(value=1L, message="Amount of memory can't be less than 1 MB") int memory, @NotBlank(message="Job working directory cannot be empty") @NotBlank(message="Job working directory cannot be empty") File dir) {
            this.bJobRequest = request;
            this.bCluster = clusterObj;
            this.bCommand = commandObj;
            this.bMemory = memory;
            this.bJobWorkingDir = dir;
        }

        public Builder withApplications(List<Application> applications) {
            this.bApplications.clear();
            if (applications != null) {
                this.bApplications.addAll(applications);
            }
            return this;
        }

        public JobExecutionEnvironment build() throws GenieException {
            return new JobExecutionEnvironment(this);
        }
    }
}

