/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.properties.ClusterSelectorScriptProperties;
import com.netflix.genie.web.scripts.ManagedScript;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ClusterSelectorScript
extends ManagedScript {
    private static final String CLUSTERS_BINDING = "clusters";
    private static final String JOB_REQUEST_BINDING = "jobRequest";

    public ClusterSelectorScript(ScriptManager scriptManager, ClusterSelectorScriptProperties properties, ObjectMapper mapper, MeterRegistry registry) {
        super(scriptManager, properties, mapper, registry);
    }

    @Nullable
    public Cluster selectCluster(JobRequest jobRequest, Set<Cluster> clusters) throws ScriptNotConfiguredException, ScriptExecutionException, GenieClusterNotFoundException {
        Set v3Clusters = clusters.stream().map(DtoConverters::toV3Cluster).collect(Collectors.toSet());
        ImmutableMap scriptParameters = ImmutableMap.of((Object)CLUSTERS_BINDING, v3Clusters, (Object)JOB_REQUEST_BINDING, (Object)jobRequest);
        String selectedClusterId = (String)this.evaluateScript((Map<String, Object>)scriptParameters);
        if (StringUtils.isBlank((CharSequence)selectedClusterId)) {
            return null;
        }
        for (Cluster cluster : clusters) {
            if (!selectedClusterId.equals(cluster.getId())) continue;
            return cluster;
        }
        throw new GenieClusterNotFoundException("No such cluster in input list: " + selectedClusterId);
    }
}

