/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobFinishedEvent;
import com.netflix.genie.web.events.JobFinishedReason;
import com.netflix.genie.web.events.KillJobEvent;
import com.netflix.genie.web.jobs.JobKillReasonFile;
import com.netflix.genie.web.util.ProcessChecker;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;

public class JobKillServiceV3 {
    private static final Logger log = LoggerFactory.getLogger(JobKillServiceV3.class);
    private final String hostname;
    private final JobSearchService jobSearchService;
    private final Executor executor;
    private final boolean runAsUser;
    private final GenieEventBus genieEventBus;
    private final File baseWorkingDir;
    private final ObjectMapper objectMapper;
    private final ProcessChecker.Factory processCheckerFactory;

    public JobKillServiceV3(@NotBlank String hostname, @NotNull JobSearchService jobSearchService, @NotNull Executor executor, boolean runAsUser, @NotNull GenieEventBus genieEventBus, @NotNull Resource genieWorkingDir, @NotNull ObjectMapper objectMapper, @NotNull ProcessChecker.Factory processCheckerFactory) {
        this.hostname = hostname;
        this.jobSearchService = jobSearchService;
        this.executor = executor;
        this.runAsUser = runAsUser;
        this.genieEventBus = genieEventBus;
        this.objectMapper = objectMapper;
        this.processCheckerFactory = processCheckerFactory;
        try {
            this.baseWorkingDir = genieWorkingDir.getFile();
        }
        catch (IOException gse) {
            throw new RuntimeException("Could not load the base path from resource", gse);
        }
    }

    public void killJob(@NotBlank(message="No id entered. Unable to kill job.") @NotBlank(message="No id entered. Unable to kill job.") String id, @NotBlank(message="No reason provided.") @NotBlank(message="No reason provided.") String reason) throws GenieException {
        JobStatus jobStatus = this.jobSearchService.getJobStatus(id);
        if (jobStatus == JobStatus.INIT) {
            this.genieEventBus.publishSynchronousEvent(new JobFinishedEvent(id, JobFinishedReason.KILLED, "User requested job be killed during initialization", this));
        } else if (jobStatus == JobStatus.RUNNING) {
            JobExecution jobExecution = this.jobSearchService.getJobExecution(id);
            if (jobExecution.getExitCode().isPresent()) {
                return;
            }
            if (!this.hostname.equals(jobExecution.getHostName())) {
                throw new GeniePreconditionException("Job with id " + id + " is not running on this host (" + this.hostname + "). It's actually on " + jobExecution.getHostName());
            }
            if (!SystemUtils.IS_OS_UNIX) {
                throw new UnsupportedOperationException("Genie isn't currently supported on this OS");
            }
            this.killJobOnUnix((Integer)jobExecution.getProcessId().orElseThrow(() -> new GeniePreconditionException("No process id found. Unable to kill if no process id")));
            try {
                this.objectMapper.writeValue(new File(this.baseWorkingDir + "/" + id + "/" + "genie/kill-reason"), (Object)new JobKillReasonFile(reason));
            }
            catch (IOException e) {
                throw new GenieServerException("Failed to write job kill reason file", (Throwable)e);
            }
        }
    }

    @EventListener
    public void onKillJobEvent(@NotNull KillJobEvent event) throws GenieException {
        this.killJob(event.getId(), event.getReason());
    }

    private void killJobOnUnix(int pid) throws GenieException {
        try {
            Instant tomorrow = Instant.now().plus(1L, ChronoUnit.DAYS);
            ProcessChecker processChecker = this.processCheckerFactory.get(pid, tomorrow);
            processChecker.checkProcess();
        }
        catch (ExecuteException ee) {
            log.debug("Process with pid {} is already done", (Object)pid);
            return;
        }
        catch (IOException ioe) {
            throw new GenieServerException("Unable to check process status for pid " + pid, (Throwable)ioe);
        }
        try {
            CommandLine killCommand;
            if (this.runAsUser) {
                killCommand = new CommandLine("sudo");
                killCommand.addArgument("kill");
            } else {
                killCommand = new CommandLine("kill");
            }
            killCommand.addArguments(Integer.toString(pid));
            this.executor.execute(killCommand);
        }
        catch (IOException ioe) {
            throw new GenieServerException("Unable to kill process " + pid, (Throwable)ioe);
        }
    }
}

