/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.web.services.ClusterSelector;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedClusterSelectorImpl
implements ClusterSelector {
    private static final Logger log = LoggerFactory.getLogger(RandomizedClusterSelectorImpl.class);

    @Override
    public Cluster selectCluster(@Nonnull @NotEmpty @NonNull Set<Cluster> clusters, @Nonnull @NonNull JobRequest jobRequest) throws GenieException {
        if (clusters == null) {
            throw new NullPointerException("clusters is marked non-null but is null");
        }
        if (jobRequest == null) {
            throw new NullPointerException("jobRequest is marked non-null but is null");
        }
        log.debug("called");
        Random rand = new Random();
        return new ArrayList<Cluster>(clusters).get(Math.abs(rand.nextInt(clusters.size())));
    }
}

