/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.selectors;

import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.scripts.ClusterSelectorScript;
import com.netflix.genie.web.services.ClusterSelector;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptClusterSelector
implements ClusterSelector {
    private static final Logger log = LoggerFactory.getLogger(ScriptClusterSelector.class);
    static final String SELECT_TIMER_NAME = "genie.jobs.clusters.selectors.script.select.timer";
    private static final Cluster NO_PREFERENCE = null;
    private final MeterRegistry registry;
    private final ClusterSelectorScript clusterSelectorScript;

    public ScriptClusterSelector(ClusterSelectorScript clusterSelectorScript, MeterRegistry registry) {
        this.clusterSelectorScript = clusterSelectorScript;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster selectCluster(@Nonnull @NotEmpty @NonNull Set<Cluster> clusters, @Nonnull @NonNull JobRequest jobRequest) throws GenieException {
        if (clusters == null) {
            throw new NullPointerException("clusters is marked non-null but is null");
        }
        if (jobRequest == null) {
            throw new NullPointerException("jobRequest is marked non-null but is null");
        }
        long selectStart = System.nanoTime();
        log.debug("Called");
        HashSet tags = Sets.newHashSet();
        try {
            Cluster selectedCluster = this.clusterSelectorScript.selectCluster(jobRequest, clusters);
            MetricsUtils.addSuccessTags(tags);
            if (selectedCluster == null) {
                log.debug("Script returned null, no preference");
                tags.add(Tag.of((String)"clusterId", (String)"null"));
                Cluster cluster = NO_PREFERENCE;
                return cluster;
            }
            tags.add(Tag.of((String)"clusterId", (String)selectedCluster.getId()));
            tags.add(Tag.of((String)"clusterName", (String)selectedCluster.getMetadata().getName()));
            Cluster cluster = selectedCluster;
            return cluster;
        }
        catch (GenieClusterNotFoundException | ScriptExecutionException | ScriptNotConfiguredException e) {
            log.error("Cluster selection error: " + ((Throwable)e).getMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException(tags, (Throwable)e);
            Cluster cluster = NO_PREFERENCE;
            return cluster;
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }
}

