/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.health;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.impl.LocalAgentLauncherImpl;
import com.netflix.genie.web.agent.services.AgentMetricsService;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.health.GenieAgentHealthIndicator;
import com.netflix.genie.web.health.GenieMemoryHealthIndicator;
import com.netflix.genie.web.health.LocalAgentLauncherHealthIndicator;
import com.netflix.genie.web.properties.HealthProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.services.JobMetricsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={HealthProperties.class})
public class HealthAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GenieMemoryHealthIndicator.class})
    public GenieMemoryHealthIndicator genieMemoryHealthIndicator(JobMetricsService jobMetricsService, JobsProperties jobsProperties) {
        return new GenieMemoryHealthIndicator(jobMetricsService, jobsProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={GenieAgentHealthIndicator.class})
    public GenieAgentHealthIndicator genieAgentHealthIndicator(AgentMetricsService agentMetricsService) {
        return new GenieAgentHealthIndicator(agentMetricsService);
    }

    @Bean
    @ConditionalOnMissingBean(value={LocalAgentLauncherHealthIndicator.class})
    @ConditionalOnBean(value={LocalAgentLauncherProperties.class, LocalAgentLauncherImpl.class})
    public LocalAgentLauncherHealthIndicator localAgentLauncherHealthIndicator(JobSearchService jobSearchService, LocalAgentLauncherProperties launcherProperties, GenieHostInfo genieHostInfo) {
        return new LocalAgentLauncherHealthIndicator(jobSearchService, launcherProperties, genieHostInfo);
    }
}

