/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.scripts;

import com.google.common.collect.Lists;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.web.properties.ClusterSelectorScriptProperties;
import com.netflix.genie.web.properties.ExecutionModeFilterScriptProperties;
import com.netflix.genie.web.properties.ScriptManagerProperties;
import com.netflix.genie.web.scripts.ClusterSelectorScript;
import com.netflix.genie.web.scripts.ExecutionModeFilterScript;
import com.netflix.genie.web.scripts.ManagedScript;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import javax.script.ScriptEngineManager;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={ClusterSelectorScriptProperties.class, ExecutionModeFilterScriptProperties.class, ScriptManagerProperties.class})
public class ScriptsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ScriptManager.class})
    ScriptManager scriptManager(ScriptManagerProperties scriptManagerProperties, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, ResourceLoader resourceLoader, MeterRegistry meterRegistry) {
        return new ScriptManager(scriptManagerProperties, taskScheduler, Executors.newCachedThreadPool(), new ScriptEngineManager(), resourceLoader, meterRegistry);
    }

    @Bean
    public ManagedScriptPreLoader managedScriptPreLoader(Optional<List<ManagedScript>> managedScrips) {
        return new ManagedScriptPreLoader(managedScrips.orElse(Lists.newArrayList()));
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterSelectorScript.class})
    @ConditionalOnProperty(value={"genie.scripts.cluster-selector.source"})
    ClusterSelectorScript clusterSelectorScript(ScriptManager scriptManager, ClusterSelectorScriptProperties scriptProperties, MeterRegistry meterRegistry) {
        return new ClusterSelectorScript(scriptManager, scriptProperties, GenieObjectMapper.getMapper(), meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExecutionModeFilterScript.class})
    @ConditionalOnProperty(value={"genie.scripts.execution-mode-filter.source"})
    ExecutionModeFilterScript executionModeFilterScript(ScriptManager scriptManager, ExecutionModeFilterScriptProperties scriptProperties, MeterRegistry meterRegistry) {
        return new ExecutionModeFilterScript(scriptManager, scriptProperties, GenieObjectMapper.getMapper(), meterRegistry);
    }

    static final class ManagedScriptPreLoader
    implements SmartInitializingSingleton {
        private List<ManagedScript> managedScripts;

        private ManagedScriptPreLoader(List<ManagedScript> managedScripts) {
            this.managedScripts = managedScripts;
        }

        public void afterSingletonsInstantiated() {
            this.managedScripts.forEach(ManagedScript::warmUp);
        }
    }
}

