/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.endpoints;

import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.internal.exceptions.checked.GenieConversionException;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieAgentRejectedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieApplicationNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieIdAlreadyExistsException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobAlreadyClaimedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobSpecificationNotFoundException;
import com.netflix.genie.proto.ChangeJobStatusError;
import com.netflix.genie.proto.ChangeJobStatusResponse;
import com.netflix.genie.proto.ClaimJobError;
import com.netflix.genie.proto.ClaimJobResponse;
import com.netflix.genie.proto.HandshakeResponse;
import com.netflix.genie.proto.JobSpecificationError;
import com.netflix.genie.proto.JobSpecificationResponse;
import com.netflix.genie.proto.ReserveJobIdError;
import com.netflix.genie.proto.ReserveJobIdResponse;
import java.util.Map;
import javax.validation.ConstraintViolationException;

public class JobServiceProtoErrorComposer {
    private static final String NO_ERROR_MESSAGE_PROVIDED = "Unknown error";
    private static final Map<Class<? extends Exception>, ReserveJobIdError.Type> RESERVE_JOB_ID_ERROR_MAP = ImmutableMap.builder().put(GenieConversionException.class, (Object)ReserveJobIdError.Type.INVALID_REQUEST).put(GenieIdAlreadyExistsException.class, (Object)ReserveJobIdError.Type.ID_NOT_AVAILABLE).build();
    private static final Map<Class<? extends Exception>, JobSpecificationError.Type> JOB_SPECIFICATION_ERROR_MAP = ImmutableMap.builder().put(GenieJobNotFoundException.class, (Object)JobSpecificationError.Type.NO_JOB_FOUND).put(GenieClusterNotFoundException.class, (Object)JobSpecificationError.Type.NO_CLUSTER_FOUND).put(GenieCommandNotFoundException.class, (Object)JobSpecificationError.Type.NO_COMMAND_FOUND).put(GenieApplicationNotFoundException.class, (Object)JobSpecificationError.Type.NO_APPLICATION_FOUND).put(GenieJobSpecificationNotFoundException.class, (Object)JobSpecificationError.Type.NO_SPECIFICATION_FOUND).put(ConstraintViolationException.class, (Object)JobSpecificationError.Type.INVALID_REQUEST).build();
    private static final Map<Class<? extends Exception>, ClaimJobError.Type> CLAIM_JOB_ERROR_MAP = ImmutableMap.builder().put(GenieJobAlreadyClaimedException.class, (Object)ClaimJobError.Type.ALREADY_CLAIMED).put(GenieJobNotFoundException.class, (Object)ClaimJobError.Type.NO_SUCH_JOB).put(GenieInvalidStatusException.class, (Object)ClaimJobError.Type.INVALID_STATUS).put(ConstraintViolationException.class, (Object)ClaimJobError.Type.INVALID_REQUEST).put(IllegalArgumentException.class, (Object)ClaimJobError.Type.INVALID_REQUEST).build();
    private static final Map<Class<? extends Exception>, ChangeJobStatusError.Type> CHANGE_JOB_STATUS_ERROR_MAP = ImmutableMap.builder().put(GenieJobNotFoundException.class, (Object)ChangeJobStatusError.Type.NO_SUCH_JOB).put(GenieInvalidStatusException.class, (Object)ChangeJobStatusError.Type.INCORRECT_CURRENT_STATUS).put(GeniePreconditionException.class, (Object)ChangeJobStatusError.Type.INVALID_REQUEST).put(ConstraintViolationException.class, (Object)ChangeJobStatusError.Type.INVALID_REQUEST).put(IllegalArgumentException.class, (Object)ChangeJobStatusError.Type.INVALID_REQUEST).build();
    private static final Map<Class<? extends Exception>, HandshakeResponse.Type> HANDSHAKE_ERROR_MAP = ImmutableMap.builder().put(ConstraintViolationException.class, (Object)HandshakeResponse.Type.INVALID_REQUEST).put(GenieAgentRejectedException.class, (Object)HandshakeResponse.Type.REJECTED).build();

    private static <T> T getErrorType(Exception e, Map<Class<? extends Exception>, T> typeMap, T defaultValue) {
        for (Map.Entry<Class<Exception>, T> typeMapEntry : typeMap.entrySet()) {
            if (!typeMapEntry.getKey().isInstance(e)) continue;
            return typeMapEntry.getValue();
        }
        return defaultValue;
    }

    private static String getMessage(Exception e) {
        return e.getClass().getCanonicalName() + ":" + (e.getMessage() == null ? NO_ERROR_MESSAGE_PROVIDED : e.getMessage());
    }

    ReserveJobIdResponse toProtoReserveJobIdResponse(Exception e) {
        return ReserveJobIdResponse.newBuilder().setError(ReserveJobIdError.newBuilder().setMessage(JobServiceProtoErrorComposer.getMessage(e)).setType(JobServiceProtoErrorComposer.getErrorType(e, RESERVE_JOB_ID_ERROR_MAP, ReserveJobIdError.Type.UNKNOWN))).build();
    }

    JobSpecificationResponse toProtoJobSpecificationResponse(Exception e) {
        Exception cause = e instanceof GenieJobResolutionException && e.getCause() != null && e.getCause() instanceof Exception ? (Exception)e.getCause() : e;
        return JobSpecificationResponse.newBuilder().setError(JobSpecificationError.newBuilder().setMessage(JobServiceProtoErrorComposer.getMessage(cause)).setType(JobServiceProtoErrorComposer.getErrorType(cause, JOB_SPECIFICATION_ERROR_MAP, JobSpecificationError.Type.UNKNOWN))).build();
    }

    ClaimJobResponse toProtoClaimJobResponse(Exception e) {
        return ClaimJobResponse.newBuilder().setSuccessful(false).setError(ClaimJobError.newBuilder().setMessage(JobServiceProtoErrorComposer.getMessage(e)).setType(JobServiceProtoErrorComposer.getErrorType(e, CLAIM_JOB_ERROR_MAP, ClaimJobError.Type.UNKNOWN))).build();
    }

    ChangeJobStatusResponse toProtoChangeJobStatusResponse(Exception e) {
        return ChangeJobStatusResponse.newBuilder().setSuccessful(false).setError(ChangeJobStatusError.newBuilder().setMessage(JobServiceProtoErrorComposer.getMessage(e)).setType(JobServiceProtoErrorComposer.getErrorType(e, CHANGE_JOB_STATUS_ERROR_MAP, ChangeJobStatusError.Type.UNKNOWN))).build();
    }

    HandshakeResponse toProtoHandshakeResponse(Exception e) {
        return HandshakeResponse.newBuilder().setMessage(JobServiceProtoErrorComposer.getMessage(e)).setType(JobServiceProtoErrorComposer.getErrorType(e, HANDSHAKE_ERROR_MAP, HandshakeResponse.Type.SERVER_ERROR)).build();
    }
}

