/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.resources;

import com.netflix.genie.web.agent.services.AgentFileStreamService;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class AgentFileProtocolResolver
implements ProtocolResolver {
    private static final Logger log = LoggerFactory.getLogger(AgentFileProtocolResolver.class);
    private static final String URI_SCHEME = "agent";
    private static final Path ROOT_PATH = Paths.get(".", new String[0]).toAbsolutePath().getRoot();
    private final AgentFileStreamService agentFileStreamService;

    public AgentFileProtocolResolver(AgentFileStreamService agentFileStreamService) {
        this.agentFileStreamService = agentFileStreamService;
    }

    public static URI createUri(String jobId, String path) throws URISyntaxException {
        String encodedJobId = Base64.encodeBase64URLSafeString((byte[])jobId.getBytes(Charset.defaultCharset()));
        return new URIBuilder().setScheme(URI_SCHEME).setHost(encodedJobId).setPath(path).build();
    }

    private static String getAgentResourceURIFileJobId(URI agentUri) {
        if (!URI_SCHEME.equals(agentUri.getScheme())) {
            throw new IllegalArgumentException("Not a valid Agent resource URI: " + agentUri);
        }
        return new String(Base64.decodeBase64((String)agentUri.getHost()), Charset.defaultCharset());
    }

    private static String getAgentResourceURIFilePath(URI agentUri) {
        if (!URI_SCHEME.equals(agentUri.getScheme())) {
            throw new IllegalArgumentException("Not a valid Agent resource URI: " + agentUri);
        }
        return agentUri.getPath();
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        Path relativePath;
        String jobId;
        URI uri;
        log.debug("Attempting to resolve if {} is an Agent file resource or not", (Object)location);
        try {
            uri = URI.create(location);
            jobId = AgentFileProtocolResolver.getAgentResourceURIFileJobId(uri);
            relativePath = ROOT_PATH.relativize(Paths.get(AgentFileProtocolResolver.getAgentResourceURIFilePath(uri), new String[0])).normalize();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.debug("{} is not a valid Agent resource (Error message: {}).", (Object)location, (Object)e.getMessage());
            return null;
        }
        AgentFileStreamService.AgentFileResource resourceOrNull = this.agentFileStreamService.getResource(jobId, relativePath, uri).orElse(null);
        if (resourceOrNull != null) {
            log.debug("Returning resource: {}", (Object)resourceOrNull.getDescription());
        }
        return resourceOrNull;
    }
}

