/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.io.ByteStreams;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.exceptions.GenieServerUnavailableException;
import com.netflix.genie.common.external.dtos.v4.ApiClientMetadata;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.checked.GenieCheckedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.apis.rest.v3.controllers.ControllerUtils;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ApplicationModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ClusterModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.CommandModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.EntityModelAssemblers;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.JobExecutionModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.JobMetadataModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.JobModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.JobRequestModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.JobSearchResultModelAssembler;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.JobCoordinatorService;
import com.netflix.genie.web.services.JobDirectoryServerService;
import com.netflix.genie.web.services.JobLaunchService;
import com.netflix.genie.web.util.JobExecutionModeSelector;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/jobs"})
public class JobRestController {
    private static final Logger log = LoggerFactory.getLogger(JobRestController.class);
    private static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    private static final String FORWARDED_FOR_HEADER = "X-Forwarded-For";
    private static final String NAME_HEADER_COOKIE = "cookie";
    private static final String JOB_API_BASE_PATH = "/api/v3/jobs/";
    private static final String COMMA = ",";
    private final JobLaunchService jobLaunchService;
    private final JobSearchService jobSearchService;
    private final JobCoordinatorService jobCoordinatorService;
    private final ApplicationModelAssembler applicationModelAssembler;
    private final ClusterModelAssembler clusterModelAssembler;
    private final CommandModelAssembler commandModelAssembler;
    private final JobModelAssembler jobModelAssembler;
    private final JobRequestModelAssembler jobRequestModelAssembler;
    private final JobExecutionModelAssembler jobExecutionModelAssembler;
    private final JobMetadataModelAssembler jobMetadataModelAssembler;
    private final JobSearchResultModelAssembler jobSearchResultModelAssembler;
    private final String hostname;
    private final RestTemplate restTemplate;
    private final JobDirectoryServerService jobDirectoryServerService;
    private final JobsProperties jobsProperties;
    private final AgentRoutingService agentRoutingService;
    private final JobPersistenceService jobPersistenceService;
    private final Environment environment;
    private final AttachmentService attachmentService;
    private final JobExecutionModeSelector jobExecutionModeSelector;
    private final Counter submitJobWithoutAttachmentsRate;
    private final Counter submitJobWithAttachmentsRate;

    @Autowired
    public JobRestController(JobLaunchService jobLaunchService, JobSearchService jobSearchService, JobCoordinatorService jobCoordinatorService, EntityModelAssemblers entityModelAssemblers, GenieHostInfo genieHostInfo, @Qualifier(value="genieRestTemplate") RestTemplate restTemplate, JobDirectoryServerService jobDirectoryServerService, JobsProperties jobsProperties, MeterRegistry registry, JobPersistenceService jobPersistenceService, AgentRoutingService agentRoutingService, Environment environment, AttachmentService attachmentService, JobExecutionModeSelector jobExecutionModeSelector) {
        this.jobLaunchService = jobLaunchService;
        this.jobSearchService = jobSearchService;
        this.jobCoordinatorService = jobCoordinatorService;
        this.applicationModelAssembler = entityModelAssemblers.getApplicationModelAssembler();
        this.clusterModelAssembler = entityModelAssemblers.getClusterModelAssembler();
        this.commandModelAssembler = entityModelAssemblers.getCommandModelAssembler();
        this.jobModelAssembler = entityModelAssemblers.getJobModelAssembler();
        this.jobRequestModelAssembler = entityModelAssemblers.getJobRequestModelAssembler();
        this.jobExecutionModelAssembler = entityModelAssemblers.getJobExecutionModelAssembler();
        this.jobMetadataModelAssembler = entityModelAssemblers.getJobMetadataModelAssembler();
        this.jobSearchResultModelAssembler = entityModelAssemblers.getJobSearchResultModelAssembler();
        this.hostname = genieHostInfo.getHostname();
        this.restTemplate = restTemplate;
        this.jobDirectoryServerService = jobDirectoryServerService;
        this.jobsProperties = jobsProperties;
        this.agentRoutingService = agentRoutingService;
        this.jobPersistenceService = jobPersistenceService;
        this.environment = environment;
        this.attachmentService = attachmentService;
        this.jobExecutionModeSelector = jobExecutionModeSelector;
        this.submitJobWithoutAttachmentsRate = registry.counter("genie.api.v3.jobs.submitJobWithoutAttachments.rate", new String[0]);
        this.submitJobWithAttachmentsRate = registry.counter("genie.api.v3.jobs.submitJobWithAttachments.rate", new String[0]);
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<Void> submitJob(@Valid @RequestBody JobRequest jobRequest, @RequestHeader(value="X-Forwarded-For", required=false) @Nullable String clientHost, @RequestHeader(value="User-Agent", required=false) @Nullable String userAgent, HttpServletRequest httpServletRequest) throws GenieException, GenieCheckedException {
        log.info("[submitJob] Called json method type to submit job: {}", (Object)jobRequest);
        this.submitJobWithoutAttachmentsRate.increment();
        return this.handleSubmitJob(jobRequest, null, clientHost, userAgent, httpServletRequest);
    }

    @PostMapping(consumes={"multipart/form-data"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public ResponseEntity<Void> submitJob(@Valid @RequestPart(value="request") JobRequest jobRequest, @RequestPart(value="attachment") MultipartFile[] attachments, @RequestHeader(value="X-Forwarded-For", required=false) @Nullable String clientHost, @RequestHeader(value="User-Agent", required=false) @Nullable String userAgent, HttpServletRequest httpServletRequest) throws GenieException, GenieCheckedException {
        log.info("[submitJob] Called multipart method to submit job: {}, with {} attachments", (Object)jobRequest, (Object)attachments.length);
        this.submitJobWithAttachmentsRate.increment();
        return this.handleSubmitJob(jobRequest, attachments, clientHost, userAgent, httpServletRequest);
    }

    private ResponseEntity<Void> handleSubmitJob(JobRequest jobRequest, @Nullable MultipartFile[] attachments, @Nullable String clientHost, @Nullable String userAgent, HttpServletRequest httpServletRequest) throws GenieException, GenieCheckedException {
        if (!((Boolean)this.environment.getProperty("genie.jobs.submission.enabled", Boolean.class, (Object)true)).booleanValue()) {
            throw new GenieServerUnavailableException(this.environment.getProperty("genie.jobs.submission.disabledMessage", "Job submission is currently disabled. Please try again later."));
        }
        String localClientHost = StringUtils.isNotBlank((CharSequence)clientHost) ? clientHost.split(COMMA)[0] : httpServletRequest.getRemoteAddr();
        boolean agentExecution = this.jobExecutionModeSelector.executeWithAgent(jobRequest, httpServletRequest);
        String jobId = agentExecution ? this.agentExecution(jobRequest, attachments, localClientHost, userAgent) : this.embeddedExecution(jobRequest, attachments, localClientHost, userAgent);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{jobId}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.ACCEPTED);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    public EntityModel<Job> getJob(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJob] Called for job with id: {}", (Object)id);
        return this.jobModelAssembler.toModel(this.jobSearchService.getJob(id));
    }

    @GetMapping(value={"/{id}/status"}, produces={"application/json"})
    public JsonNode getJobStatus(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobStatus] Called for job with id: {}", (Object)id);
        JsonNodeFactory factory = JsonNodeFactory.instance;
        return factory.objectNode().set("status", (JsonNode)factory.textNode(DtoConverters.toV3JobStatus((com.netflix.genie.common.external.dtos.v4.JobStatus)this.jobPersistenceService.getJobStatus(id)).toString()));
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedModel<EntityModel<JobSearchResult>> findJobs(@RequestParam(value="id", required=false) @Nullable String id, @RequestParam(value="name", required=false) @Nullable String name, @RequestParam(value="user", required=false) @Nullable String user, @RequestParam(value="status", required=false) @Nullable Set<String> statuses, @RequestParam(value="tag", required=false) @Nullable Set<String> tags, @RequestParam(value="clusterName", required=false) @Nullable String clusterName, @RequestParam(value="clusterId", required=false) @Nullable String clusterId, @RequestParam(value="commandName", required=false) @Nullable String commandName, @RequestParam(value="commandId", required=false) @Nullable String commandId, @RequestParam(value="minStarted", required=false) @Nullable Long minStarted, @RequestParam(value="maxStarted", required=false) @Nullable Long maxStarted, @RequestParam(value="minFinished", required=false) @Nullable Long minFinished, @RequestParam(value="maxFinished", required=false) @Nullable Long maxFinished, @RequestParam(value="grouping", required=false) @Nullable String grouping, @RequestParam(value="groupingInstance", required=false) @Nullable String groupingInstance, @PageableDefault(sort={"created"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<JobSearchResult> assembler) throws GenieException {
        log.info("[getJobs] Called with [id | jobName | user | statuses | clusterName | clusterId | minStarted | maxStarted | minFinished | maxFinished | grouping | groupingInstance | page]\n{} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {} | {}", new Object[]{id, name, user, statuses, tags, clusterName, clusterId, commandName, commandId, minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance, page});
        EnumSet<JobStatus> enumStatuses = null;
        if (statuses != null && !statuses.isEmpty()) {
            enumStatuses = EnumSet.noneOf(JobStatus.class);
            for (String status : statuses) {
                if (!StringUtils.isNotBlank((CharSequence)status)) continue;
                enumStatuses.add(JobStatus.parse((String)status));
            }
        }
        Link self = WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).findJobs(id, name, user, statuses, tags, clusterName, clusterId, commandName, commandId, minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance, page, assembler)).withSelfRel();
        return assembler.toModel(this.jobSearchService.findJobs(id, name, user, enumStatuses, tags, clusterName, clusterId, commandName, commandId, minStarted == null ? null : Instant.ofEpochMilli(minStarted), maxStarted == null ? null : Instant.ofEpochMilli(maxStarted), minFinished == null ? null : Instant.ofEpochMilli(minFinished), maxFinished == null ? null : Instant.ofEpochMilli(maxFinished), grouping, groupingInstance, page), (RepresentationModelAssembler)this.jobSearchResultModelAssembler, self);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public void killJob(@PathVariable(value="id") String id, @RequestHeader(name="Genie-Forwarded-From", required=false) @Nullable String forwardedFrom, HttpServletRequest request, HttpServletResponse response) throws GenieException, IOException {
        log.info("[killJob] Called for job id: {}. Forwarded from: {}", (Object)id, (Object)forwardedFrom);
        if (this.jobPersistenceService.getJobStatus(id).isFinished()) {
            return;
        }
        if (this.jobsProperties.getForwarding().isEnabled() && forwardedFrom == null) {
            String jobHostname;
            try {
                jobHostname = this.getJobOwnerHostname(id, this.jobPersistenceService.isV4(id));
            }
            catch (GenieJobNotFoundException e) {
                throw new GenieNotFoundException("Job " + id + " not found", (Throwable)e);
            }
            if (!this.hostname.equals(jobHostname)) {
                log.info("Job {} is not on this node. Forwarding kill request to {}", (Object)id, (Object)jobHostname);
                String forwardHost = this.buildForwardHost(jobHostname);
                try {
                    this.restTemplate.execute(forwardHost + JOB_API_BASE_PATH + id, HttpMethod.DELETE, forwardRequest -> this.copyRequestHeaders(request, forwardRequest), forwardResponse -> {
                        response.setStatus(HttpStatus.ACCEPTED.value());
                        this.copyResponseHeaders(response, forwardResponse);
                        return null;
                    }, new Object[0]);
                }
                catch (HttpStatusCodeException e) {
                    log.error("Failed killing job on {}. Error: {}", (Object)forwardHost, (Object)e.getMessage());
                    response.sendError(e.getStatusCode().value(), e.getStatusText());
                }
                catch (Exception e) {
                    log.error("Failed killing job on {}. Error: {}", (Object)forwardHost, (Object)e.getMessage());
                    response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
                }
                return;
            }
        }
        log.info("Job {} is on this node. Attempting to kill.", (Object)id);
        this.jobCoordinatorService.killJob(id, "Job was killed by user.");
        response.setStatus(HttpStatus.ACCEPTED.value());
    }

    @GetMapping(value={"/{id}/request"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<JobRequest> getJobRequest(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobRequest] Called for job request with id {}", (Object)id);
        return this.jobRequestModelAssembler.toModel(this.jobSearchService.getJobRequest(id));
    }

    @GetMapping(value={"/{id}/execution"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<JobExecution> getJobExecution(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobExecution] Called for job execution with id {}", (Object)id);
        return this.jobExecutionModelAssembler.toModel(this.jobSearchService.getJobExecution(id));
    }

    @GetMapping(value={"/{id}/metadata"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<JobMetadata> getJobMetadata(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobMetadata] Called for job metadata with id {}", (Object)id);
        return this.jobMetadataModelAssembler.toModel(this.jobSearchService.getJobMetadata(id));
    }

    @GetMapping(value={"/{id}/cluster"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<Cluster> getJobCluster(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobCluster] Called for job with id {}", (Object)id);
        return this.clusterModelAssembler.toModel(this.jobSearchService.getJobCluster(id));
    }

    @GetMapping(value={"/{id}/command"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<Command> getJobCommand(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobCommand] Called for job with id {}", (Object)id);
        return this.commandModelAssembler.toModel(this.jobSearchService.getJobCommand(id));
    }

    @GetMapping(value={"/{id}/applications"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<EntityModel<Application>> getJobApplications(@PathVariable(value="id") String id) throws GenieException {
        log.info("[getJobApplications] Called for job with id {}", (Object)id);
        return this.jobSearchService.getJobApplications(id).stream().map(this.applicationModelAssembler::toModel).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}/output", "/{id}/output/", "/{id}/output/**"})
    public void getJobOutput(@PathVariable(value="id") String id, @RequestHeader(name="Genie-Forwarded-From", required=false) @Nullable String forwardedFrom, HttpServletRequest request, HttpServletResponse response) throws GenieException {
        String jobHostname;
        URL baseUrl;
        boolean isV4 = this.jobPersistenceService.isV4(id);
        com.netflix.genie.common.external.dtos.v4.JobStatus jobStatus = this.jobPersistenceService.getJobStatus(id);
        String path = ControllerUtils.getRemainingPath(request);
        try {
            baseUrl = forwardedFrom == null ? ControllerUtils.getRequestRoot(request, path) : ControllerUtils.getRequestRoot(new URL(forwardedFrom), path);
        }
        catch (MalformedURLException e) {
            throw new GenieServerException("Unable to parse base request url", (Throwable)e);
        }
        log.info("[getJobOutput] Called to get output path \"{}\" for job with id \"{}\"", (Object)path, (Object)id);
        if (jobStatus.isActive() && this.jobsProperties.getForwarding().isEnabled() && forwardedFrom == null && !this.hostname.equals(jobHostname = this.getJobOwnerHostname(id, isV4))) {
            log.info("Job {} is not run on this node. Forwarding to {}", (Object)id, (Object)jobHostname);
            String forwardHost = this.buildForwardHost(jobHostname);
            try {
                this.restTemplate.execute(forwardHost + JOB_API_BASE_PATH + id + "/output/" + path, HttpMethod.GET, forwardRequest -> this.copyRequestHeaders(request, forwardRequest), forwardResponse -> {
                    response.setStatus(forwardResponse.getStatusCode().value());
                    this.copyResponseHeaders(response, forwardResponse);
                    ByteStreams.copy((InputStream)forwardResponse.getBody(), (OutputStream)response.getOutputStream());
                    return null;
                }, new Object[0]);
            }
            catch (HttpClientErrorException.NotFound e) {
                throw new GenieNotFoundException("Not Found (via: " + forwardHost + ")", (Throwable)e);
            }
            catch (HttpStatusCodeException e) {
                throw new GenieException(e.getStatusCode().value(), "Proxied request failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error("Failed getting the remote job output from {}. Error: {}", (Object)forwardHost, (Object)e.getMessage());
                throw new GenieServerException("Proxied request error:" + e.getMessage(), (Throwable)e);
            }
            return;
        }
        log.debug("Fetching requested resource \"{}\" for job \"{}\"", (Object)path, (Object)id);
        this.jobDirectoryServerService.serveResource(id, baseUrl, path, request, response);
    }

    private String buildForwardHost(String jobHostname) {
        return this.jobsProperties.getForwarding().getScheme() + "://" + jobHostname + ":" + this.jobsProperties.getForwarding().getPort();
    }

    private void copyRequestHeaders(HttpServletRequest request, ClientHttpRequest forwardRequest) {
        Cookie[] cookies;
        HttpHeaders headers = forwardRequest.getHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (NAME_HEADER_COOKIE.equals(headerName)) continue;
                String headerValue = request.getHeader(headerName);
                log.debug("Request Header: name = {} value = {}", (Object)headerName, (Object)headerValue);
                headers.add(headerName, headerValue);
            }
        }
        if ((cookies = request.getCookies()) != null && cookies.length > 0) {
            StringBuilder builder = null;
            for (Cookie cookie : request.getCookies()) {
                if (builder == null) {
                    builder = new StringBuilder();
                } else {
                    builder.append(COMMA);
                }
                builder.append(cookie.getName()).append("=").append(cookie.getValue());
            }
            if (builder != null) {
                String cookieValue = builder.toString();
                headers.add(NAME_HEADER_COOKIE, cookieValue);
                log.debug("Request Header: name = {} value = {}", (Object)NAME_HEADER_COOKIE, (Object)cookieValue);
            }
        }
        headers.add("Genie-Forwarded-From", request.getRequestURL().toString());
    }

    private void copyResponseHeaders(HttpServletResponse response, ClientHttpResponse forwardResponse) {
        HttpHeaders headers = forwardResponse.getHeaders();
        for (Map.Entry header : headers.toSingleValueMap().entrySet()) {
            if (TRANSFER_ENCODING_HEADER.equalsIgnoreCase((String)header.getKey())) continue;
            response.setHeader((String)header.getKey(), (String)header.getValue());
        }
    }

    private String getJobOwnerHostname(@NotBlank(message="No job id entered. Unable to find the job owner.") @NotBlank(message="No job id entered. Unable to find the job owner.") String jobId, boolean isV4) throws GenieNotFoundException {
        if (isV4) {
            return this.agentRoutingService.getHostnameForAgentConnection(jobId).orElseThrow(() -> new GenieNotFoundException("No hostname found for v4 job - " + jobId));
        }
        return this.jobSearchService.getJobHost(jobId);
    }

    private String embeddedExecution(JobRequest jobRequest, @Nullable MultipartFile[] attachments, String clientHost, @Nullable String userAgent) throws GenieException {
        JobRequest jobRequestWithId;
        String jobId;
        Optional jobIdOptional = jobRequest.getId();
        if (jobIdOptional.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)jobIdOptional.get()))) {
            jobId = (String)jobIdOptional.get();
            jobRequestWithId = jobRequest;
        } else {
            jobId = UUID.randomUUID().toString();
            JobRequest.Builder builder = ((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequest.getName(), jobRequest.getUser(), jobRequest.getVersion(), jobRequest.getClusterCriterias(), jobRequest.getCommandCriteria()).withId(jobId)).withDisableLogArchival(jobRequest.isDisableLogArchival()).withTags(jobRequest.getTags())).withConfigs(jobRequest.getConfigs())).withDependencies(jobRequest.getDependencies())).withApplications(jobRequest.getApplications());
            jobRequest.getCommandArgs().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withCommandArgs(arg_0));
            jobRequest.getCpu().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withCpu(arg_0));
            jobRequest.getMemory().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMemory(arg_0));
            jobRequest.getGroup().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroup(arg_0));
            jobRequest.getSetupFile().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withSetupFile(arg_0));
            jobRequest.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withDescription(arg_0));
            jobRequest.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withEmail(arg_0));
            jobRequest.getTimeout().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withTimeout(arg_0));
            jobRequest.getMetadata().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMetadata(arg_0));
            jobRequest.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGrouping(arg_0));
            jobRequest.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroupingInstance(arg_0));
            jobRequestWithId = builder.build();
        }
        int numAttachments = 0;
        long totalSizeOfAttachments = 0L;
        if (attachments != null) {
            log.info("Saving attachments for job {}", (Object)jobId);
            numAttachments = attachments.length;
            for (MultipartFile attachment : attachments) {
                totalSizeOfAttachments += attachment.getSize();
                log.info("Attachment for job: {} name: {} Size: {}", new Object[]{jobId, attachment.getOriginalFilename(), attachment.getSize()});
                try {
                    String originalFilename = attachment.getOriginalFilename();
                    if (originalFilename == null) {
                        originalFilename = UUID.randomUUID().toString();
                    }
                    this.attachmentService.save(jobId, originalFilename, attachment.getInputStream());
                }
                catch (IOException ioe) {
                    throw new GenieServerException("Failed to save job attachment", (Throwable)ioe);
                }
            }
        }
        JobMetadata metadata = new JobMetadata.Builder().withClientHost(clientHost).withUserAgent(userAgent).withNumAttachments(Integer.valueOf(numAttachments)).withTotalSizeOfAttachments(Long.valueOf(totalSizeOfAttachments)).build();
        this.jobCoordinatorService.coordinateJob(jobRequestWithId, metadata);
        return jobId;
    }

    private String agentExecution(JobRequest jobRequest, @Nullable MultipartFile[] attachments, String clientHost, @Nullable String userAgent) throws GenieException, GenieCheckedException {
        int numAttachments = 0;
        long totalSizeOfAttachments = 0L;
        if (attachments != null) {
            numAttachments = attachments.length;
            for (MultipartFile attachment : attachments) {
                totalSizeOfAttachments += attachment.getSize();
            }
        }
        JobRequestMetadata metadata = new JobRequestMetadata(new ApiClientMetadata(clientHost, userAgent), null, numAttachments, totalSizeOfAttachments);
        JobSubmission.Builder jobSubmissionBuilder = new JobSubmission.Builder(DtoConverters.toV4JobRequest((JobRequest)jobRequest, (boolean)true), metadata);
        if (attachments != null) {
            jobSubmissionBuilder.withAttachments(Arrays.stream(attachments).map(MultipartFile::getResource).collect(Collectors.toSet()));
        }
        return this.jobLaunchService.launchJob(jobSubmissionBuilder.build());
    }
}

