/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.ClusterRestController;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class ClusterModelAssembler
implements RepresentationModelAssembler<Cluster, EntityModel<Cluster>> {
    private static final String COMMANDS_LINK = "commands";

    @Nonnull
    public EntityModel<Cluster> toModel(Cluster cluster) {
        String id = (String)cluster.getId().orElseThrow(IllegalArgumentException::new);
        EntityModel clusterModel = new EntityModel((Object)cluster, new Link[0]);
        try {
            clusterModel.add(WebMvcLinkBuilder.linkTo(((ClusterRestController)WebMvcLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCluster(id)).withSelfRel());
            clusterModel.add(WebMvcLinkBuilder.linkTo(((ClusterRestController)WebMvcLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCommandsForCluster(id, null)).withRel(COMMANDS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return clusterModel;
    }
}

