/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.CommandRestController;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class CommandModelAssembler
implements RepresentationModelAssembler<Command, EntityModel<Command>> {
    private static final String APPLICATIONS_LINK = "applications";
    private static final String CLUSTERS_LINK = "clusters";

    @Nonnull
    public EntityModel<Command> toModel(Command command) {
        String id = (String)command.getId().orElseThrow(IllegalArgumentException::new);
        EntityModel commandModel = new EntityModel((Object)command, new Link[0]);
        try {
            commandModel.add(WebMvcLinkBuilder.linkTo(((CommandRestController)WebMvcLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getCommand(id)).withSelfRel());
            commandModel.add(WebMvcLinkBuilder.linkTo(((CommandRestController)WebMvcLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getApplicationsForCommand(id)).withRel(APPLICATIONS_LINK));
            commandModel.add(WebMvcLinkBuilder.linkTo(((CommandRestController)WebMvcLinkBuilder.methodOn(CommandRestController.class, (Object[])new Object[0])).getClustersForCommand(id, null)).withRel(CLUSTERS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return commandModel;
    }
}

