/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class JobModelAssembler
implements RepresentationModelAssembler<Job, EntityModel<Job>> {
    private static final String REQUEST_LINK = "request";
    private static final String EXECUTION_LINK = "execution";
    private static final String OUTPUT_LINK = "output";
    private static final String STATUS_LINK = "status";
    private static final String METADATA_LINK = "metadata";
    private static final String CLUSTER_LINK = "cluster";
    private static final String COMMAND_LINK = "command";
    private static final String APPLICATIONS_LINK = "applications";

    @Nonnull
    public EntityModel<Job> toModel(Job job) {
        String id = (String)job.getId().orElseThrow(IllegalArgumentException::new);
        EntityModel jobModel = new EntityModel((Object)job, new Link[0]);
        try {
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id)).withSelfRel());
            jobModel.add(((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)OUTPUT_LINK)).withRel(OUTPUT_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id)).withRel(REQUEST_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id)).withRel(EXECUTION_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id)).withRel(METADATA_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo((Object)((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel(STATUS_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobCluster(id)).withRel(CLUSTER_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobCommand(id)).withRel(COMMAND_LINK));
            jobModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobApplications(id)).withRel(APPLICATIONS_LINK));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobModel;
    }
}

