/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.entities;

import com.netflix.genie.web.data.entities.AuditEntity;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@MappedSuperclass
public class UniqueIdEntity
extends AuditEntity {
    @Basic(optional=false)
    @Column(name="unique_id", nullable=false, unique=true, updatable=false)
    @NotBlank(message="A unique identifier is missing and is required.")
    @Size(max=255, message="Max length in database is 255 characters")
    private @NotBlank(message="A unique identifier is missing and is required.") @Size(max=255, message="Max length in database is 255 characters") String uniqueId = UUID.randomUUID().toString();
    @Basic(optional=false)
    @Column(name="requested_id", nullable=false, updatable=false)
    private boolean requestedId;

    public String getUniqueId() {
        return this.uniqueId;
    }

    public boolean isRequestedId() {
        return this.requestedId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setRequestedId(boolean requestedId) {
        this.requestedId = requestedId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniqueIdEntity)) {
            return false;
        }
        UniqueIdEntity other = (UniqueIdEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        return !(this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UniqueIdEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UniqueIdEntity(super=" + super.toString() + ", uniqueId=" + this.uniqueId + ", requestedId=" + this.requestedId + ")";
    }
}

