/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.repositories.jpa;

import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.web.data.repositories.jpa.CriteriaResolutionRepository;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;

public class CriteriaResolutionRepositoryImpl
implements CriteriaResolutionRepository {
    private static final String CLUSTER_QUERY_STRING = "{CLUSTER_QUERY_HERE}";
    private static final String COMMAND_QUERY_STRING = "{COMMAND_QUERY_HERE}";
    private static final String RESOLVE_CLUSTERS_AND_COMMANDS_QUERY = "SELECT   cc.cluster_id,  c.unique_id FROM  (    SELECT      cc.cluster_id as cluster_id,      MIN(cc.command_order) as command_order    FROM      ({CLUSTER_QUERY_HERE}) AS selected_clusters join      clusters_commands cc ON selected_clusters.id = cc.cluster_id join      ({COMMAND_QUERY_HERE}) AS selected_commands ON selected_commands.id = cc.command_id    GROUP BY cc.cluster_id  ) as cluster_id_order join  clusters_commands cc on    cluster_id_order.cluster_id = cc.cluster_id AND    cc.command_order = cluster_id_order.command_order join  commands c on cc.command_id = c.id;";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Nonnull
    public List<Object[]> resolveClustersAndCommands(Criterion clusterCriterion, Criterion commandCriterion) {
        return this.entityManager.createNativeQuery(RESOLVE_CLUSTERS_AND_COMMANDS_QUERY.replace(CLUSTER_QUERY_STRING, this.buildEntityQueryForType(clusterCriterion, CriteriaType.CLUSTER)).replace(COMMAND_QUERY_STRING, this.buildEntityQueryForType(commandCriterion, CriteriaType.COMMAND))).getResultList();
    }

    private String buildEntityQueryForType(Criterion criterion, CriteriaType criteriaType) {
        String unwrappedStatus;
        Optional criterionStatus;
        Set tags = criterion.getTags();
        boolean hasTags = !tags.isEmpty();
        StringBuilder query = new StringBuilder();
        query.append("SELECT c.id as id FROM ").append(criteriaType.getPrimaryTable()).append(" c");
        if (hasTags) {
            query.append(" join ").append(criteriaType.getTagTable()).append(" ct on c.id = ct.").append(criteriaType.getTagJoinColumn()).append(" join tags t on ct.tag_id = t.id");
        }
        query.append(" WHERE");
        criterion.getId().ifPresent(id -> {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                query.append(" c.unique_id = '").append((String)id).append("' AND");
            }
        });
        criterion.getName().ifPresent(name -> {
            if (StringUtils.isNotBlank((CharSequence)name)) {
                query.append(" c.name = '").append((String)name).append("' AND");
            }
        });
        criterion.getVersion().ifPresent(version -> {
            if (StringUtils.isNotBlank((CharSequence)version)) {
                query.append(" c.version = '").append((String)version).append("' AND");
            }
        });
        if (hasTags) {
            query.append(" t.tag IN (").append(criterion.getTags().stream().map(tag -> "'" + tag + "'").reduce((first, second) -> first + ", " + second).orElse("")).append(") AND");
        }
        String status = (criterionStatus = criterion.getStatus()).isPresent() ? (StringUtils.isBlank((CharSequence)(unwrappedStatus = (String)criterionStatus.get())) ? criteriaType.getDefaultStatus() : unwrappedStatus) : criteriaType.getDefaultStatus();
        query.append(" c.status = '").append(status).append("'");
        if (hasTags) {
            query.append(" GROUP BY c.id HAVING COUNT(c.id) = ").append(criterion.getTags().size());
        }
        return query.toString();
    }

    private static enum CriteriaType {
        CLUSTER("clusters", "clusters_tags", "cluster_id", ClusterStatus.UP.name()),
        COMMAND("commands", "commands_tags", "command_id", CommandStatus.ACTIVE.name());

        private final String primaryTable;
        private final String tagTable;
        private final String tagJoinColumn;
        private final String defaultStatus;

        private CriteriaType(String primaryTable, String tagTable, String tagJoinColumn, String defaultStatus) {
            this.primaryTable = primaryTable;
            this.tagTable = tagTable;
            this.tagJoinColumn = tagJoinColumn;
            this.defaultStatus = defaultStatus;
        }

        public String getPrimaryTable() {
            return this.primaryTable;
        }

        public String getTagTable() {
            return this.tagTable;
        }

        public String getTagJoinColumn() {
            return this.tagJoinColumn;
        }

        public String getDefaultStatus() {
            return this.defaultStatus;
        }
    }
}

