/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.web.data.entities.BaseEntity;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.JobEntity;
import com.netflix.genie.web.data.entities.JobEntity_;
import com.netflix.genie.web.data.entities.projections.AgentHostnameProjection;
import com.netflix.genie.web.data.entities.projections.JobApplicationsProjection;
import com.netflix.genie.web.data.entities.projections.JobClusterProjection;
import com.netflix.genie.web.data.entities.projections.JobCommandProjection;
import com.netflix.genie.web.data.entities.projections.JobExecutionProjection;
import com.netflix.genie.web.data.entities.projections.JobMetadataProjection;
import com.netflix.genie.web.data.entities.projections.JobProjection;
import com.netflix.genie.web.data.entities.projections.JobRequestProjection;
import com.netflix.genie.web.data.entities.projections.StatusProjection;
import com.netflix.genie.web.data.entities.projections.UniqueIdProjection;
import com.netflix.genie.web.data.repositories.jpa.JpaBaseRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaClusterRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaCommandRepository;
import com.netflix.genie.web.data.repositories.jpa.JpaJobRepository;
import com.netflix.genie.web.data.repositories.jpa.specifications.JpaJobSpecs;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.data.services.jpa.JpaServiceUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaJobSearchServiceImpl
implements JobSearchService {
    private static final Logger log = LoggerFactory.getLogger(JpaJobSearchServiceImpl.class);
    @VisibleForTesting
    static final Set<String> ACTIVE_STATUS_SET = com.netflix.genie.common.dto.JobStatus.getActiveStatuses().stream().map(Enum::name).collect(Collectors.toSet());
    @VisibleForTesting
    static final Set<String> USING_MEMORY_JOB_SET = Stream.of(com.netflix.genie.common.dto.JobStatus.CLAIMED, com.netflix.genie.common.dto.JobStatus.INIT, com.netflix.genie.common.dto.JobStatus.RUNNING).map(Enum::name).collect(Collectors.toSet());
    private final JpaJobRepository jobRepository;
    private final JpaClusterRepository clusterRepository;
    private final JpaCommandRepository commandRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public JpaJobSearchServiceImpl(JpaJobRepository jobRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        this.jobRepository = jobRepository;
        this.clusterRepository = clusterRepository;
        this.commandRepository = commandRepository;
    }

    @Override
    public Page<JobSearchResult> findJobs(@Nullable String id, @Nullable String jobName, @Nullable String user, @Nullable Set<com.netflix.genie.common.dto.JobStatus> statuses, @Nullable Set<String> tags, @Nullable String clusterName, @Nullable String clusterId, @Nullable String commandName, @Nullable String commandId, @Nullable Instant minStarted, @Nullable Instant maxStarted, @Nullable Instant minFinished, @Nullable Instant maxFinished, @Nullable String grouping, @Nullable String groupingInstance, @NotNull Pageable page) {
        log.debug("called");
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(JobEntity.class);
        ClusterEntity clusterEntity = null;
        if (clusterId != null) {
            Optional<ClusterEntity> optionalClusterEntity = this.getEntityOrNull(this.clusterRepository, clusterId, clusterName);
            if (optionalClusterEntity.isPresent()) {
                clusterEntity = optionalClusterEntity.get();
            } else {
                return new PageImpl((List)Lists.newArrayList(), page, 0L);
            }
        }
        CommandEntity commandEntity = null;
        if (commandId != null) {
            Optional<CommandEntity> optionalCommandEntity = this.getEntityOrNull(this.commandRepository, commandId, commandName);
            if (optionalCommandEntity.isPresent()) {
                commandEntity = optionalCommandEntity.get();
            } else {
                return new PageImpl((List)Lists.newArrayList(), page, 0L);
            }
        }
        Predicate whereClause = JpaJobSpecs.getFindPredicate((Root<JobEntity>)root, cb, id, jobName, user, statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null, tags, clusterName, clusterEntity, commandName, commandEntity, minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance);
        countQuery.select((Selection)cb.count((Expression)root)).where((Expression)whereClause);
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        if (count > 0L) {
            CriteriaQuery contentQuery = cb.createQuery(JobSearchResult.class);
            contentQuery.from(JobEntity.class);
            contentQuery.multiselect(new Selection[]{root.get(JobEntity_.uniqueId), root.get(JobEntity_.name), root.get(JobEntity_.user), root.get(JobEntity_.status), root.get(JobEntity_.started), root.get(JobEntity_.finished), root.get(JobEntity_.clusterName), root.get(JobEntity_.commandName)});
            contentQuery.where((Expression)whereClause);
            Sort sort = page.getSort();
            ArrayList orders = new ArrayList();
            sort.iterator().forEachRemaining(order -> {
                if (order.isAscending()) {
                    orders.add(cb.asc((Expression)root.get(order.getProperty())));
                } else {
                    orders.add(cb.desc((Expression)root.get(order.getProperty())));
                }
            });
            contentQuery.orderBy(orders);
            List results = this.entityManager.createQuery(contentQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
            return new PageImpl(results, page, count.longValue());
        }
        return new PageImpl((List)Lists.newArrayList(), page, count.longValue());
    }

    @Override
    public Set<Job> getAllActiveJobsOnHost(@NotBlank String hostname) {
        log.debug("Called with hostname {}", (Object)hostname);
        Set<JobProjection> jobs = this.jobRepository.findByAgentHostnameAndStatusIn(hostname, ACTIVE_STATUS_SET);
        return jobs.stream().map(JpaServiceUtils::toJobDto).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getAllHostsWithActiveJobs() {
        log.debug("Called");
        return this.jobRepository.findDistinctByStatusInAndV4IsFalse(ACTIVE_STATUS_SET).stream().map(AgentHostnameProjection::getAgentHostname).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Job getJob(@NotBlank(message="No id entered. Unable to get job.") @NotBlank(message="No id entered. Unable to get job.") String id) throws GenieNotFoundException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobDto(this.jobRepository.findByUniqueId(id, JobProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id)));
    }

    @Override
    @Deprecated
    public com.netflix.genie.common.dto.JobStatus getJobStatus(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return DtoConverters.toV3JobStatus((JobStatus)DtoConverters.toV4JobStatus((String)this.jobRepository.findByUniqueId(id, StatusProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists.")).getStatus()));
    }

    @Override
    public JobRequest getJobRequest(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobRequestDto(this.jobRepository.findByUniqueId(id, JobRequestProjection.class).orElseThrow(() -> new GenieNotFoundException("No job request with id " + id)));
    }

    @Override
    public JobExecution getJobExecution(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobExecutionDto(this.jobRepository.findByUniqueId(id, JobExecutionProjection.class).orElseThrow(() -> new GenieNotFoundException("No job execution with id " + id)));
    }

    @Override
    public Cluster getJobCluster(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return JpaServiceUtils.toClusterDto(this.jobRepository.findByUniqueId(id, JobClusterProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to get cluster")).getCluster().orElseThrow(() -> new GenieNotFoundException("Job " + id + " doesn't have a cluster associated with it")));
    }

    @Override
    public Command getJobCommand(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return JpaServiceUtils.toCommandDto(this.jobRepository.findByUniqueId(id, JobCommandProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to get command")).getCommand().orElseThrow(() -> new GenieNotFoundException("Job " + id + " doesn't have a command associated with it")));
    }

    @Override
    public List<Application> getJobApplications(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return this.jobRepository.findByUniqueId(id, JobApplicationsProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with " + id + " exists. Unable to get applications")).getApplications().stream().map(JpaServiceUtils::toApplicationDto).collect(Collectors.toList());
    }

    @Override
    public String getJobHost(@NotBlank String jobId) throws GenieNotFoundException {
        return this.jobRepository.findByUniqueId(jobId, AgentHostnameProjection.class).orElseThrow(() -> new GenieNotFoundException("No job execution found for id " + jobId)).getAgentHostname().orElseThrow(() -> new GenieNotFoundException("No hostname set for job " + jobId));
    }

    @Override
    public long getActiveJobCountForUser(@NotBlank String user) throws GenieException {
        log.debug("Called for jobs with user {}", (Object)user);
        Long count = this.jobRepository.countJobsByUserAndStatusIn(user, ACTIVE_STATUS_SET);
        if (count == null || count < 0L) {
            throw new GenieServerException("Count query for user " + user + "produced an unexpected result: " + count);
        }
        return count;
    }

    @Override
    public JobMetadata getJobMetadata(@NotBlank String id) throws GenieException {
        return JpaServiceUtils.toJobMetadataDto(this.jobRepository.findByUniqueId(id, JobMetadataProjection.class).orElseThrow(() -> new GenieNotFoundException("No job metadata found for id " + id)));
    }

    @Override
    public Map<String, UserResourcesSummary> getUserResourcesSummaries() {
        return this.jobRepository.getUserJobResourcesAggregates().stream().map(JpaServiceUtils::toUserResourceSummaryDto).collect(Collectors.toMap(UserResourcesSummary::getUser, userResourcesSummary -> userResourcesSummary));
    }

    @Override
    public Set<String> getActiveDisconnectedAgentJobs() {
        return this.jobRepository.getAgentJobIdsWithNoConnectionInState(ACTIVE_STATUS_SET).stream().map(UniqueIdProjection::getUniqueId).collect(Collectors.toSet());
    }

    @Override
    public long getAllocatedMemoryOnHost(String hostname) {
        return this.jobRepository.getTotalMemoryUsedOnHost(hostname, ACTIVE_STATUS_SET);
    }

    @Override
    public long getUsedMemoryOnHost(String hostname) {
        return this.jobRepository.getTotalMemoryUsedOnHost(hostname, USING_MEMORY_JOB_SET);
    }

    @Override
    public long getActiveJobCountOnHost(String hostname) {
        return this.jobRepository.countByAgentHostnameAndStatusIn(hostname, ACTIVE_STATUS_SET);
    }

    private <E extends BaseEntity> Optional<E> getEntityOrNull(JpaBaseRepository<E> repository, String id, @Nullable String name) {
        Optional<E> optionalEntity = repository.findByUniqueId(id);
        if (optionalEntity.isPresent()) {
            BaseEntity entity = (BaseEntity)optionalEntity.get();
            if (name != null && !entity.getName().equals(name)) {
                return Optional.empty();
            }
        }
        return optionalEntity;
    }
}

