/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.CommonDTO;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.external.dtos.v4.ApplicationStatus;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.web.data.entities.ApplicationEntity;
import com.netflix.genie.web.data.entities.BaseEntity;
import com.netflix.genie.web.data.entities.ClusterEntity;
import com.netflix.genie.web.data.entities.CommandEntity;
import com.netflix.genie.web.data.entities.FileEntity;
import com.netflix.genie.web.data.entities.TagEntity;
import com.netflix.genie.web.data.entities.aggregates.UserJobResourcesAggregate;
import com.netflix.genie.web.data.entities.projections.BaseProjection;
import com.netflix.genie.web.data.entities.projections.JobExecutionProjection;
import com.netflix.genie.web.data.entities.projections.JobMetadataProjection;
import com.netflix.genie.web.data.entities.projections.JobProjection;
import com.netflix.genie.web.data.entities.projections.JobRequestProjection;
import com.netflix.genie.web.data.entities.v4.EntityDtoConverters;
import java.time.Instant;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JpaServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(JpaServiceUtils.class);

    private JpaServiceUtils() {
    }

    static Application toApplicationDto(ApplicationEntity applicationEntity) {
        Application.Builder builder = (Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)new Application.Builder(applicationEntity.getName(), applicationEntity.getUser(), applicationEntity.getVersion(), DtoConverters.toV3ApplicationStatus((ApplicationStatus)DtoConverters.toV4ApplicationStatus((String)applicationEntity.getStatus()))).withId(applicationEntity.getUniqueId())).withCreated(applicationEntity.getCreated())).withUpdated(applicationEntity.getUpdated())).withTags(applicationEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withConfigs(applicationEntity.getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withDependencies(applicationEntity.getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet()));
        applicationEntity.getType().ifPresent(arg_0 -> ((Application.Builder)builder).withType(arg_0));
        applicationEntity.getDescription().ifPresent(arg_0 -> ((Application.Builder)builder).withDescription(arg_0));
        applicationEntity.getSetupFile().ifPresent(setupFileEntity -> {
            Application.Builder cfr_ignored_0 = (Application.Builder)builder.withSetupFile(setupFileEntity.getFile());
        });
        JpaServiceUtils.setDtoMetadata(builder, applicationEntity);
        return builder.build();
    }

    static Cluster toClusterDto(ClusterEntity clusterEntity) {
        Cluster.Builder builder = (Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)new Cluster.Builder(clusterEntity.getName(), clusterEntity.getUser(), clusterEntity.getVersion(), DtoConverters.toV3ClusterStatus((ClusterStatus)DtoConverters.toV4ClusterStatus((String)clusterEntity.getStatus()))).withId(clusterEntity.getUniqueId())).withCreated(clusterEntity.getCreated())).withUpdated(clusterEntity.getUpdated())).withTags(clusterEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withConfigs(clusterEntity.getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withDependencies(clusterEntity.getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet()));
        clusterEntity.getDescription().ifPresent(arg_0 -> ((Cluster.Builder)builder).withDescription(arg_0));
        clusterEntity.getSetupFile().ifPresent(setupFileEntity -> {
            Cluster.Builder cfr_ignored_0 = (Cluster.Builder)builder.withSetupFile(setupFileEntity.getFile());
        });
        JpaServiceUtils.setDtoMetadata(builder, clusterEntity);
        return builder.build();
    }

    static Command toCommandDto(CommandEntity commandEntity) {
        Command.Builder builder = (Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)new Command.Builder(commandEntity.getName(), commandEntity.getUser(), commandEntity.getVersion(), DtoConverters.toV3CommandStatus((CommandStatus)DtoConverters.toV4CommandStatus((String)commandEntity.getStatus())), commandEntity.getExecutable(), commandEntity.getCheckDelay()).withId(commandEntity.getUniqueId())).withCreated(commandEntity.getCreated())).withUpdated(commandEntity.getUpdated())).withTags(commandEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withConfigs(commandEntity.getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withDependencies(commandEntity.getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet()));
        commandEntity.getMemory().ifPresent(arg_0 -> ((Command.Builder)builder).withMemory(arg_0));
        commandEntity.getDescription().ifPresent(arg_0 -> ((Command.Builder)builder).withDescription(arg_0));
        commandEntity.getSetupFile().ifPresent(setupFileEntity -> {
            Command.Builder cfr_ignored_0 = (Command.Builder)builder.withSetupFile(setupFileEntity.getFile());
        });
        JpaServiceUtils.setDtoMetadata(builder, commandEntity);
        builder.withClusterCriteria(commandEntity.getClusterCriteria().stream().map(EntityDtoConverters::toCriterionDto).collect(Collectors.toList()));
        return builder.build();
    }

    static Job toJobDto(JobProjection jobProjection) {
        Job.Builder builder = ((Job.Builder)((Job.Builder)((Job.Builder)((Job.Builder)new Job.Builder(jobProjection.getName(), jobProjection.getUser(), jobProjection.getVersion()).withId(jobProjection.getUniqueId())).withCreated(jobProjection.getCreated())).withUpdated(jobProjection.getUpdated())).withTags(jobProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withStatus(DtoConverters.toV3JobStatus((JobStatus)DtoConverters.toV4JobStatus((String)jobProjection.getStatus()))).withCommandArgs(jobProjection.getCommandArgs());
        jobProjection.getDescription().ifPresent(arg_0 -> ((Job.Builder)builder).withDescription(arg_0));
        jobProjection.getStatusMsg().ifPresent(arg_0 -> ((Job.Builder)builder).withStatusMsg(arg_0));
        jobProjection.getStarted().ifPresent(arg_0 -> ((Job.Builder)builder).withStarted(arg_0));
        jobProjection.getFinished().ifPresent(arg_0 -> ((Job.Builder)builder).withFinished(arg_0));
        jobProjection.getArchiveLocation().ifPresent(arg_0 -> ((Job.Builder)builder).withArchiveLocation(arg_0));
        jobProjection.getClusterName().ifPresent(arg_0 -> ((Job.Builder)builder).withClusterName(arg_0));
        jobProjection.getCommandName().ifPresent(arg_0 -> ((Job.Builder)builder).withCommandName(arg_0));
        jobProjection.getGrouping().ifPresent(arg_0 -> ((Job.Builder)builder).withGrouping(arg_0));
        jobProjection.getGroupingInstance().ifPresent(arg_0 -> ((Job.Builder)builder).withGroupingInstance(arg_0));
        JpaServiceUtils.setDtoMetadata(builder, jobProjection);
        return builder.build();
    }

    static JobRequest toJobRequestDto(JobRequestProjection jobRequestProjection) {
        JobRequest.Builder builder = ((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequestProjection.getName(), jobRequestProjection.getUser(), jobRequestProjection.getVersion(), jobRequestProjection.getClusterCriteria().stream().map(EntityDtoConverters::toCriterionDto).map(DtoConverters::toClusterCriteria).collect(Collectors.toList()), (Set)DtoConverters.toV3CriterionTags((Criterion)EntityDtoConverters.toCriterionDto(jobRequestProjection.getCommandCriterion()))).withCreated(jobRequestProjection.getCreated())).withId(jobRequestProjection.getUniqueId())).withDisableLogArchival(jobRequestProjection.isArchivingDisabled()).withConfigs(jobRequestProjection.getConfigs().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withDependencies(jobRequestProjection.getDependencies().stream().map(FileEntity::getFile).collect(Collectors.toSet()))).withTags(jobRequestProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()))).withUpdated(jobRequestProjection.getUpdated())).withApplications(jobRequestProjection.getRequestedApplications()).withCommandArgs(jobRequestProjection.getCommandArgs());
        jobRequestProjection.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withEmail(arg_0));
        jobRequestProjection.getGenieUserGroup().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroup(arg_0));
        jobRequestProjection.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withDescription(arg_0));
        jobRequestProjection.getRequestedCpu().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withCpu(arg_0));
        jobRequestProjection.getRequestedMemory().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withMemory(arg_0));
        jobRequestProjection.getRequestedTimeout().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withTimeout(arg_0));
        jobRequestProjection.getSetupFile().ifPresent(setupFileEntity -> {
            JobRequest.Builder cfr_ignored_0 = (JobRequest.Builder)builder.withSetupFile(setupFileEntity.getFile());
        });
        jobRequestProjection.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGrouping(arg_0));
        jobRequestProjection.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)builder).withGroupingInstance(arg_0));
        JpaServiceUtils.setDtoMetadata(builder, jobRequestProjection);
        return builder.build();
    }

    static JobExecution toJobExecutionDto(JobExecutionProjection jobExecutionProjection) {
        JobExecution.Builder builder = (JobExecution.Builder)((JobExecution.Builder)((JobExecution.Builder)new JobExecution.Builder(jobExecutionProjection.getAgentHostname().orElse(UUID.randomUUID().toString())).withId(jobExecutionProjection.getUniqueId())).withCreated(jobExecutionProjection.getCreated())).withUpdated(jobExecutionProjection.getUpdated());
        jobExecutionProjection.getProcessId().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withProcessId(arg_0));
        jobExecutionProjection.getCheckDelay().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withCheckDelay(arg_0));
        if (jobExecutionProjection.getStarted().isPresent() && jobExecutionProjection.getTimeoutUsed().isPresent()) {
            Instant started = jobExecutionProjection.getStarted().get();
            builder.withTimeout(started.plusSeconds(jobExecutionProjection.getTimeoutUsed().get().intValue()));
        }
        jobExecutionProjection.getExitCode().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withExitCode(arg_0));
        jobExecutionProjection.getMemoryUsed().ifPresent(arg_0 -> ((JobExecution.Builder)builder).withMemory(arg_0));
        return builder.build();
    }

    static JobMetadata toJobMetadataDto(JobMetadataProjection jobMetadataProjection) {
        JobMetadata.Builder builder = (JobMetadata.Builder)((JobMetadata.Builder)((JobMetadata.Builder)new JobMetadata.Builder().withId(jobMetadataProjection.getUniqueId())).withCreated(jobMetadataProjection.getCreated())).withUpdated(jobMetadataProjection.getUpdated());
        jobMetadataProjection.getRequestApiClientHostname().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withClientHost(arg_0));
        jobMetadataProjection.getRequestApiClientUserAgent().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withUserAgent(arg_0));
        jobMetadataProjection.getNumAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withNumAttachments(arg_0));
        jobMetadataProjection.getTotalSizeOfAttachments().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withTotalSizeOfAttachments(arg_0));
        jobMetadataProjection.getStdErrSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdErrSize(arg_0));
        jobMetadataProjection.getStdOutSize().ifPresent(arg_0 -> ((JobMetadata.Builder)builder).withStdOutSize(arg_0));
        return builder.build();
    }

    private static <B extends CommonDTO.Builder, E extends BaseProjection> void setDtoMetadata(B builder, E entity) {
        if (entity.getMetadata().isPresent()) {
            try {
                String metadata = entity.getMetadata().get();
                builder.withMetadata(metadata);
            }
            catch (GeniePreconditionException gpe) {
                log.error("Invalid JSON metadata. Should never happen.", (Throwable)gpe);
                builder.withMetadata((JsonNode)null);
            }
        }
    }

    static <D extends CommonDTO, E extends BaseEntity> void setEntityMetadata(ObjectMapper mapper, D dto, E entity) {
        if (dto.getMetadata().isPresent()) {
            try {
                entity.setMetadata(mapper.writeValueAsString(dto.getMetadata().get()));
            }
            catch (JsonProcessingException jpe) {
                log.error("Invalid JSON, unable to convert to string", (Throwable)jpe);
                entity.setMetadata(null);
            }
        } else {
            entity.setMetadata(null);
        }
    }

    static UserResourcesSummary toUserResourceSummaryDto(UserJobResourcesAggregate userJobResourcesAggregate) {
        String user = userJobResourcesAggregate.getUser();
        Long jobCount = userJobResourcesAggregate.getRunningJobsCount();
        Long memory = userJobResourcesAggregate.getUsedMemory();
        return new UserResourcesSummary(user == null ? "NULL" : user, jobCount == null ? 0L : jobCount, memory == null ? 0L : memory);
    }
}

