/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.web.jobs.AdminResources;
import com.netflix.genie.web.jobs.FileType;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(ClusterTask.class);
    private static final String CLUSTER_TASK_TIMER_NAME = "genie.jobs.tasks.clusterTask.timer";
    private final GenieFileTransferService fts;

    public ClusterTask(@NotNull MeterRegistry registry, @NotNull GenieFileTransferService fts) {
        super(registry);
        this.fts = fts;
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            String localPath;
            String clusterSetupFile;
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            Cluster cluster = jobExecEnv.getCluster();
            tags.add(Tag.of((String)"clusterName", (String)cluster.getMetadata().getName()));
            tags.add(Tag.of((String)"clusterId", (String)cluster.getId()));
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            String genieDir = jobWorkingDirectory + "/" + "genie";
            Writer writer = (Writer)context.get("writer");
            log.info("Starting Cluster Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            String clusterId = cluster.getId();
            this.createEntityInstanceDirectory(genieDir, clusterId, AdminResources.CLUSTER);
            this.createEntityInstanceConfigDirectory(genieDir, clusterId, AdminResources.CLUSTER);
            this.createEntityInstanceDependenciesDirectory(genieDir, clusterId, AdminResources.CLUSTER);
            Optional setupFile = cluster.getResources().getSetupFile();
            if (setupFile.isPresent() && StringUtils.isNotBlank((CharSequence)(clusterSetupFile = (String)setupFile.get()))) {
                String localPath2 = super.buildLocalFilePath(jobWorkingDirectory, clusterId, clusterSetupFile, FileType.SETUP, AdminResources.CLUSTER);
                this.fts.getFile(clusterSetupFile, localPath2);
                super.generateSetupFileSourceSnippet(clusterId, "Cluster:", localPath2, writer, jobWorkingDirectory);
            }
            for (String configFile : cluster.getResources().getConfigs()) {
                localPath = super.buildLocalFilePath(jobWorkingDirectory, clusterId, configFile, FileType.CONFIG, AdminResources.CLUSTER);
                this.fts.getFile(configFile, localPath);
            }
            for (String dependencyFile : cluster.getResources().getDependencies()) {
                localPath = super.buildLocalFilePath(jobWorkingDirectory, clusterId, dependencyFile, FileType.DEPENDENCIES, AdminResources.CLUSTER);
                this.fts.getFile(dependencyFile, localPath);
            }
            log.info("Finished Cluster Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(CLUSTER_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

