/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.properties.ExecutionModeFilterScriptProperties;
import com.netflix.genie.web.scripts.ManagedScript;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionModeFilterScript
extends ManagedScript {
    private static final Logger log = LoggerFactory.getLogger(ExecutionModeFilterScript.class);
    private static final String JOB_REQUEST_BINDING = "jobRequest";

    public ExecutionModeFilterScript(ScriptManager scriptManager, ExecutionModeFilterScriptProperties properties, ObjectMapper mapper, MeterRegistry registry) {
        super(scriptManager, properties, mapper, registry);
    }

    public Optional<Boolean> forceAgentExecution(JobRequest jobRequest) throws ScriptNotConfiguredException, ScriptExecutionException {
        ImmutableMap scriptParameters = ImmutableMap.of((Object)JOB_REQUEST_BINDING, (Object)jobRequest);
        Object scriptOutput = this.evaluateScript((Map<String, Object>)scriptParameters);
        log.debug("Execution mode selector returned: {} for job request: {}", scriptOutput, (Object)jobRequest);
        if (scriptOutput == null) {
            return Optional.empty();
        }
        if (scriptOutput instanceof Boolean) {
            return Optional.of((Boolean)scriptOutput);
        }
        throw new ScriptExecutionException("Script returned unexpected value: " + scriptOutput);
    }
}

