/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.genie.web.exceptions.checked.ScriptExecutionException;
import com.netflix.genie.web.exceptions.checked.ScriptNotConfiguredException;
import com.netflix.genie.web.scripts.ManagedScriptBaseProperties;
import com.netflix.genie.web.scripts.ScriptManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.Map;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ManagedScript {
    private static final Logger log = LoggerFactory.getLogger(ManagedScript.class);
    protected final ObjectMapper mapper;
    private final ScriptManager scriptManager;
    private final ManagedScriptBaseProperties properties;
    private final MeterRegistry registry;

    protected ManagedScript(ScriptManager scriptManager, ManagedScriptBaseProperties properties, ObjectMapper mapper, MeterRegistry registry) {
        this.scriptManager = scriptManager;
        this.properties = properties;
        this.mapper = mapper;
        this.registry = registry;
    }

    public void warmUp() {
        URI scriptUri = this.properties.getSource();
        if (this.properties.isAutoLoadEnabled() && scriptUri != null) {
            this.scriptManager.manageScript(scriptUri);
        }
    }

    protected Object evaluateScript(Map<String, Object> scriptParameters) throws ScriptExecutionException, ScriptNotConfiguredException {
        URI scriptUri = this.properties.getSource();
        if (scriptUri == null) {
            throw new ScriptNotConfiguredException("Script source URI not set");
        }
        SimpleBindings bindings = new SimpleBindings();
        for (Map.Entry<String, Object> parameterEntry : scriptParameters.entrySet()) {
            String parameterValue;
            String parameterName = parameterEntry.getKey();
            try {
                parameterValue = this.mapper.writeValueAsString(parameterEntry.getValue());
            }
            catch (JsonProcessingException e) {
                throw new ScriptExecutionException("Failed to convert parameter: " + parameterName, e);
            }
            bindings.put(parameterName, (Object)parameterValue);
        }
        return this.scriptManager.evaluateScript(scriptUri, bindings, this.properties.getTimeout());
    }

    @VisibleForTesting
    boolean isReadyToEvaluate() {
        URI scriptUri = this.properties.getSource();
        return scriptUri != null && this.scriptManager.isLoaded(scriptUri);
    }

    public ManagedScriptBaseProperties getProperties() {
        return this.properties;
    }
}

