/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.DirectoryManifest;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.dtos.ArchivedJobMetadata;
import com.netflix.genie.web.exceptions.checked.JobDirectoryManifestNotFoundException;
import com.netflix.genie.web.exceptions.checked.JobNotArchivedException;
import com.netflix.genie.web.exceptions.checked.JobNotFoundException;
import com.netflix.genie.web.services.ArchivedJobService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class ArchivedJobServiceImpl
implements ArchivedJobService {
    private static final Logger log = LoggerFactory.getLogger(ArchivedJobServiceImpl.class);
    @VisibleForTesting
    static final String GET_METADATA_NUM_RETRY_PROPERTY_NAME = "genie.retry.archived-job-get-metadata.noOfRetries";
    private static final String GET_METADATA_INITIAL_DELAY_PROPERTY_NAME = "genie.retry.archived-job-get-metadata.noOfRetries";
    private static final String GET_METADATA_MULTIPLIER_PROPERTY_NAME = "genie.retry.archived-job-get-metadata.multiplier";
    private static final String SLASH = "/";
    private static final String GET_ARCHIVED_JOB_METADATA_METRIC_NAME = "genie.web.services.archivedJobService.getArchivedJobMetadata.timer";
    private final JobPersistenceService jobPersistenceService;
    private final ResourceLoader resourceLoader;
    private final MeterRegistry meterRegistry;

    public ArchivedJobServiceImpl(JobPersistenceService jobPersistenceService, ResourceLoader resourceLoader, MeterRegistry meterRegistry) {
        this.jobPersistenceService = jobPersistenceService;
        this.resourceLoader = resourceLoader;
        this.meterRegistry = meterRegistry;
    }

    @Override
    @Cacheable(cacheNames={"archivedJobMetadata"}, sync=true)
    @Retryable(maxAttemptsExpression="#{${genie.retry.archived-job-get-metadata.noOfRetries:5}}", include={JobDirectoryManifestNotFoundException.class}, backoff=@Backoff(delayExpression="#{${genie.retry.archived-job-get-metadata.noOfRetries:1000}}", multiplierExpression="#{${genie.retry.archived-job-get-metadata.multiplier:2.0}}"))
    public ArchivedJobMetadata getArchivedJobMetadata(String jobId) throws JobNotFoundException, JobNotArchivedException, JobDirectoryManifestNotFoundException {
        Instant startTime = Instant.now();
        log.debug("Attempting to fetch archived job metadata for job {}", (Object)jobId);
        HashSet tags = Sets.newHashSet();
        try {
            DirectoryManifest manifest;
            URI jobDirectoryRoot;
            String archiveLocation;
            try {
                archiveLocation = this.jobPersistenceService.getJobArchiveLocation(jobId).orElseThrow(() -> new JobNotArchivedException("Job " + jobId + " wasn't archived"));
            }
            catch (GenieNotFoundException nfe) {
                throw new JobNotFoundException(nfe);
            }
            try {
                jobDirectoryRoot = new URI(archiveLocation + SLASH).normalize();
            }
            catch (URISyntaxException e) {
                throw new GenieRuntimeException("Unable to create URI from archive location: " + archiveLocation, (Throwable)e);
            }
            URI manifestLocation = StringUtils.isBlank((CharSequence)"genie") ? jobDirectoryRoot.resolve("manifest.json").normalize() : jobDirectoryRoot.resolve("genie/").resolve("manifest.json").normalize();
            Resource manifestResource = this.resourceLoader.getResource(manifestLocation.toString());
            if (!manifestResource.exists()) {
                throw new JobDirectoryManifestNotFoundException("No job directory manifest exists at " + manifestLocation);
            }
            try (InputStream manifestData = manifestResource.getInputStream();){
                manifest = (DirectoryManifest)GenieObjectMapper.getMapper().readValue(manifestData, DirectoryManifest.class);
            }
            catch (IOException e) {
                throw new GenieRuntimeException("Unable to read job directory manifest from " + manifestLocation, (Throwable)e);
            }
            MetricsUtils.addSuccessTags(tags);
            ArchivedJobMetadata archivedJobMetadata = new ArchivedJobMetadata(jobId, manifest, jobDirectoryRoot);
            return archivedJobMetadata;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            log.debug("Finished attempting to fetch archived job metadata for job {}", (Object)jobId);
            this.meterRegistry.timer(GET_ARCHIVED_JOB_METADATA_METRIC_NAME, (Iterable)tags).record(Duration.between(startTime, Instant.now()));
        }
    }
}

