/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.exceptions.GenieServerUnavailableException;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.DirectoryManifest;
import com.netflix.genie.common.internal.services.JobDirectoryManifestCreatorService;
import com.netflix.genie.web.agent.resources.AgentFileProtocolResolver;
import com.netflix.genie.web.agent.services.AgentFileStreamService;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.dtos.ArchivedJobMetadata;
import com.netflix.genie.web.exceptions.checked.JobDirectoryManifestNotFoundException;
import com.netflix.genie.web.exceptions.checked.JobNotArchivedException;
import com.netflix.genie.web.exceptions.checked.JobNotFoundException;
import com.netflix.genie.web.resources.writers.DefaultDirectoryWriter;
import com.netflix.genie.web.services.ArchivedJobService;
import com.netflix.genie.web.services.JobDirectoryServerService;
import com.netflix.genie.web.services.JobFileService;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class JobDirectoryServerServiceImpl
implements JobDirectoryServerService {
    private static final Logger log = LoggerFactory.getLogger(JobDirectoryServerServiceImpl.class);
    private static final String SLASH = "/";
    private final ResourceLoader resourceLoader;
    private final JobPersistenceService jobPersistenceService;
    private final JobFileService jobFileService;
    private final AgentFileStreamService agentFileStreamService;
    private final MeterRegistry meterRegistry;
    private final GenieResourceHandler.Factory genieResourceHandlerFactory;
    private final JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService;
    private final ArchivedJobService archivedJobService;

    public JobDirectoryServerServiceImpl(ResourceLoader resourceLoader, JobPersistenceService jobPersistenceService, AgentFileStreamService agentFileStreamService, ArchivedJobService archivedJobService, MeterRegistry meterRegistry, JobFileService jobFileService, JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService) {
        this(resourceLoader, jobPersistenceService, agentFileStreamService, archivedJobService, new GenieResourceHandler.Factory(), meterRegistry, jobFileService, jobDirectoryManifestCreatorService);
    }

    @VisibleForTesting
    JobDirectoryServerServiceImpl(ResourceLoader resourceLoader, JobPersistenceService jobPersistenceService, AgentFileStreamService agentFileStreamService, ArchivedJobService archivedJobService, GenieResourceHandler.Factory genieResourceHandlerFactory, MeterRegistry meterRegistry, JobFileService jobFileService, JobDirectoryManifestCreatorService jobDirectoryManifestCreatorService) {
        this.resourceLoader = resourceLoader;
        this.jobPersistenceService = jobPersistenceService;
        this.jobFileService = jobFileService;
        this.agentFileStreamService = agentFileStreamService;
        this.meterRegistry = meterRegistry;
        this.genieResourceHandlerFactory = genieResourceHandlerFactory;
        this.jobDirectoryManifestCreatorService = jobDirectoryManifestCreatorService;
        this.archivedJobService = archivedJobService;
    }

    @Override
    public void serveResource(String jobId, URL baseUrl, String relativePath, HttpServletRequest request, HttpServletResponse response) throws GenieException {
        URI jobDirRoot;
        DirectoryManifest manifest;
        URI baseUri;
        JobStatus jobStatus = this.jobPersistenceService.getJobStatus(jobId);
        boolean isV4 = this.jobPersistenceService.isV4(jobId);
        try {
            baseUri = new URI(baseUrl.toString() + SLASH).normalize();
        }
        catch (URISyntaxException e) {
            throw new GenieServerException("Unable to convert " + baseUrl + " to valid URI", (Throwable)e);
        }
        if (jobStatus.isActive() && isV4) {
            manifest = this.agentFileStreamService.getManifest(jobId).orElseThrow(() -> new GenieServerUnavailableException("Manifest not found for job " + jobId));
            try {
                jobDirRoot = AgentFileProtocolResolver.createUri(jobId, SLASH);
            }
            catch (URISyntaxException e) {
                throw new GenieServerException("Failed to construct job directory path", (Throwable)e);
            }
        }
        if (jobStatus.isActive()) {
            Resource jobDir = this.jobFileService.getJobFileAsResource(jobId, "");
            if (!jobDir.exists()) {
                throw new GenieNotFoundException("Job directory does not exist: " + jobDir);
            }
            try {
                jobDirRoot = new URI(jobDir.getURI().toString() + SLASH).normalize();
            }
            catch (IOException | URISyntaxException e) {
                throw new GenieServerException("Failed to normalize job directory path", (Throwable)e);
            }
            Path jobDirPath = Paths.get(jobDirRoot);
            try {
                manifest = this.jobDirectoryManifestCreatorService.getDirectoryManifest(jobDirPath);
            }
            catch (IOException e) {
                throw new GenieServerException("Failed to construct manifest: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            ArchivedJobMetadata archivedJobMetadata = this.archivedJobService.getArchivedJobMetadata(jobId);
            manifest = archivedJobMetadata.getManifest();
            jobDirRoot = archivedJobMetadata.getArchiveBaseUri();
        }
        catch (JobNotArchivedException e) {
            throw new GeniePreconditionException("Job outputs were not archived", (Throwable)((Object)e));
        }
        catch (JobDirectoryManifestNotFoundException | JobNotFoundException e) {
            throw new GenieNotFoundException("Failed to retrieve job archived files metadata", (Throwable)e);
        }
        catch (Exception e) {
            throw new GenieServerException("Error job metadata: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.handleRequest(baseUri, relativePath, request, response, manifest, jobDirRoot);
        }
        catch (IOException e) {
            throw new GenieServerException("Error serving response: " + e.getMessage(), (Throwable)e);
        }
    }

    private void handleRequest(URI baseUri, String relativePath, HttpServletRequest request, HttpServletResponse response, DirectoryManifest manifest, URI jobDirectoryRoot) throws IOException, GenieNotFoundException, GenieServerException {
        log.debug("Handle request, baseUri: '{}', relpath: '{}', jobRootUri: '{}'", new Object[]{baseUri, relativePath, jobDirectoryRoot});
        DirectoryManifest.ManifestEntry entry = (DirectoryManifest.ManifestEntry)manifest.getEntry(relativePath).orElseThrow(() -> new GenieNotFoundException("No such entry in job manifest: " + relativePath));
        if (entry.isDirectory()) {
            DefaultDirectoryWriter.Directory directory = new DefaultDirectoryWriter.Directory();
            ArrayList files = Lists.newArrayList();
            ArrayList directories = Lists.newArrayList();
            try {
                entry.getParent().ifPresent(parentPath -> {
                    DirectoryManifest.ManifestEntry parentEntry = (DirectoryManifest.ManifestEntry)manifest.getEntry(parentPath).orElseThrow(IllegalArgumentException::new);
                    directory.setParent(this.createEntry(parentEntry, baseUri));
                });
                for (String childPath : entry.getChildren()) {
                    DirectoryManifest.ManifestEntry childEntry = (DirectoryManifest.ManifestEntry)manifest.getEntry(childPath).orElseThrow(IllegalArgumentException::new);
                    if (childEntry.isDirectory()) {
                        directories.add(this.createEntry(childEntry, baseUri));
                        continue;
                    }
                    files.add(this.createEntry(childEntry, baseUri));
                }
            }
            catch (IllegalArgumentException iae) {
                throw new GenieServerException("Error while traversing files manifest: " + iae.getMessage(), (Throwable)iae);
            }
            directories.sort(Comparator.comparing(DefaultDirectoryWriter.Entry::getName));
            files.sort(Comparator.comparing(DefaultDirectoryWriter.Entry::getName));
            directory.setDirectories(directories);
            directory.setFiles(files);
            String accept = request.getHeader("Accept");
            if (accept != null && accept.contains("text/html")) {
                response.setContentType("text/html");
                response.getOutputStream().write(DefaultDirectoryWriter.directoryToHTML(entry.getName(), directory).getBytes(StandardCharsets.UTF_8));
            } else {
                response.setContentType("application/json");
                GenieObjectMapper.getMapper().writeValue((OutputStream)response.getOutputStream(), (Object)directory);
            }
        } else {
            URI location = jobDirectoryRoot.resolve(entry.getPath());
            log.debug("Get resource: {}", (Object)location);
            Resource jobResource = this.resourceLoader.getResource(location.toString());
            String mediaType = entry.getMimeType().orElse("text/plain");
            ResourceHttpRequestHandler handler = this.genieResourceHandlerFactory.get(mediaType, jobResource);
            try {
                handler.handleRequest(request, response);
            }
            catch (ServletException e) {
                throw new GenieServerException("Servlet exception: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private DefaultDirectoryWriter.Entry createEntry(DirectoryManifest.ManifestEntry manifestEntry, URI baseUri) {
        DefaultDirectoryWriter.Entry entry = new DefaultDirectoryWriter.Entry();
        if (manifestEntry.isDirectory()) {
            entry.setName(manifestEntry.getName().endsWith(SLASH) ? manifestEntry.getName() : manifestEntry.getName() + SLASH);
        } else {
            entry.setName(manifestEntry.getName());
        }
        entry.setUrl(baseUri.resolve(manifestEntry.getPath()).toString());
        entry.setSize(manifestEntry.getSize());
        entry.setLastModified(manifestEntry.getLastModifiedTime());
        return entry;
    }

    private static class GenieResourceHandler
    extends ResourceHttpRequestHandler {
        private static final ResourceHttpMessageConverter RESOURCE_HTTP_MESSAGE_CONVERTER = new ResourceHttpMessageConverter();
        private static final ResourceRegionHttpMessageConverter RESOURCE_REGION_HTTP_MESSAGE_CONVERTER = new ResourceRegionHttpMessageConverter();
        private final MediaType mediaType;
        private final Resource jobResource;

        GenieResourceHandler(String mediaType, Resource jobResource) {
            this.mediaType = MediaType.parseMediaType((String)mediaType);
            this.jobResource = jobResource;
            this.setResourceHttpMessageConverter(RESOURCE_HTTP_MESSAGE_CONVERTER);
            this.setResourceRegionHttpMessageConverter(RESOURCE_REGION_HTTP_MESSAGE_CONVERTER);
        }

        protected Resource getResource(HttpServletRequest request) throws IOException {
            return this.jobResource;
        }

        protected MediaType getMediaType(HttpServletRequest request, Resource resource) {
            return this.mediaType;
        }

        private static class Factory {
            private Factory() {
            }

            ResourceHttpRequestHandler get(String mediaType, Resource jobResource) {
                return new GenieResourceHandler(mediaType, jobResource);
            }
        }
    }
}

