/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.dtos.v4.JobEnvironment;
import com.netflix.genie.common.external.dtos.v4.JobMetadata;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.web.data.services.ApplicationPersistenceService;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.CommandPersistenceService;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.ClusterSelector;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetClassAware;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class JobResolverServiceImpl
implements JobResolverService {
    private static final Logger log = LoggerFactory.getLogger(JobResolverServiceImpl.class);
    private static final String RESOLVE_JOB_TIMER = "genie.services.jobResolver.resolve.timer";
    private static final String CLUSTER_COMMAND_QUERY_TIMER_NAME = "genie.services.jobResolver.clusterCommandQuery.timer";
    private static final String SELECT_CLUSTER_TIMER_NAME = "genie.services.jobResolver.selectCluster.timer";
    private static final String SELECT_COMMAND_TIMER_NAME = "genie.services.jobResolver.selectCommand.timer";
    private static final String SELECT_APPLICATIONS_TIMER_NAME = "genie.services.jobResolver.selectApplications.timer";
    private static final String CLUSTER_SELECTOR_COUNTER_NAME = "genie.services.jobResolver.clusterSelector.counter";
    private static final String NO_ID_FOUND = "No id found";
    private static final Tag SAVED_TAG = Tag.of((String)"saved", (String)"true");
    private static final Tag NOT_SAVED_TAG = Tag.of((String)"saved", (String)"false");
    private static final String CLUSTER_SELECTOR_STATUS_SUCCESS = "success";
    private static final String CLUSTER_SELECTOR_STATUS_NO_PREFERENCE = "no preference";
    private static final String CLUSTER_SELECTOR_STATUS_EXCEPTION = "exception";
    private static final String CLUSTER_SELECTOR_STATUS_INVALID = "invalid";
    private final ApplicationPersistenceService applicationPersistenceService;
    private final ClusterPersistenceService clusterPersistenceService;
    private final CommandPersistenceService commandPersistenceService;
    private final JobPersistenceService jobPersistenceService;
    private final List<ClusterSelector> clusterSelectorImpls;
    private final MeterRegistry registry;
    private final int defaultMemory;
    private final File defaultJobDirectory;
    private final String defaultArchiveLocation;
    private final Counter noClusterSelectedCounter;
    private final Counter noClusterFoundCounter;

    public JobResolverServiceImpl(ApplicationPersistenceService applicationPersistenceService, ClusterPersistenceService clusterPersistenceService, CommandPersistenceService commandPersistenceService, JobPersistenceService jobPersistenceService, @NotEmpty List<ClusterSelector> clusterSelectorImpls, MeterRegistry registry, JobsProperties jobsProperties) {
        this.applicationPersistenceService = applicationPersistenceService;
        this.clusterPersistenceService = clusterPersistenceService;
        this.commandPersistenceService = commandPersistenceService;
        this.jobPersistenceService = jobPersistenceService;
        this.clusterSelectorImpls = clusterSelectorImpls;
        this.defaultMemory = jobsProperties.getMemory().getDefaultJobMemory();
        URI jobDirProperty = jobsProperties.getLocations().getJobs();
        this.defaultJobDirectory = Paths.get(jobDirProperty).toFile();
        this.defaultArchiveLocation = jobsProperties.getLocations().getArchives().toString();
        this.registry = registry;
        this.noClusterSelectedCounter = this.registry.counter("genie.services.jobResolver.selectCluster.noneSelected.counter", new String[0]);
        this.noClusterFoundCounter = this.registry.counter("genie.services.jobResolver.selectCluster.noneFound.counter", new String[0]);
    }

    @Override
    @Nonnull
    @Transactional
    public ResolvedJob resolveJob(String id) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{SAVED_TAG});
        try {
            log.info("Received request to resolve a job with id {}", (Object)id);
            JobStatus jobStatus = this.jobPersistenceService.getJobStatus(id);
            if (!jobStatus.isResolvable()) {
                throw new IllegalArgumentException("Job " + id + " is already resolved: " + jobStatus);
            }
            com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest = this.jobPersistenceService.getJobRequest(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists."));
            boolean apiJob = this.jobPersistenceService.isApiJob(id);
            ResolvedJob resolvedJob = this.resolve(id, jobRequest, apiJob);
            this.jobPersistenceService.saveResolvedJob(id, resolvedJob);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    @Nonnull
    public ResolvedJob resolveJob(String id, @Valid com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, boolean apiJob) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{NOT_SAVED_TAG});
        try {
            log.info("Received request to resolve a job for id {} and request {}", (Object)id, (Object)jobRequest);
            ResolvedJob resolvedJob = this.resolve(id, jobRequest, apiJob);
            MetricsUtils.addSuccessTags(tags);
            ResolvedJob resolvedJob2 = resolvedJob;
            return resolvedJob2;
        }
        catch (GenieJobResolutionException e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(RESOLVE_JOB_TIMER, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private ResolvedJob resolve(String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, boolean apiJob) throws GenieJobResolutionException {
        Map<Cluster, String> clustersAndCommandsForJob = this.queryForClustersAndCommands(jobRequest.getCriteria().getClusterCriteria(), jobRequest.getCriteria().getCommandCriterion());
        Cluster cluster = this.selectCluster(id, jobRequest, clustersAndCommandsForJob.keySet());
        Command command = this.getCommand(clustersAndCommandsForJob.get(cluster), id);
        ArrayList applicationResources = Lists.newArrayList();
        for (Application application : this.getApplications(id, jobRequest, command)) {
            applicationResources.add(new JobSpecification.ExecutionResource(application.getId(), application.getResources()));
        }
        int jobMemory = this.resolveJobMemory(jobRequest, command);
        ImmutableMap<String, String> environmentVariables = this.generateEnvironmentVariables(id, jobRequest, cluster, command, jobMemory);
        Integer timeout = jobRequest.getRequestedAgentConfig().getTimeoutRequested().isPresent() ? (Integer)jobRequest.getRequestedAgentConfig().getTimeoutRequested().get() : (apiJob ? Integer.valueOf(604800) : null);
        JobSpecification jobSpecification = new JobSpecification(command.getExecutable(), jobRequest.getCommandArgs(), new JobSpecification.ExecutionResource(id, jobRequest.getResources()), new JobSpecification.ExecutionResource(cluster.getId(), cluster.getResources()), new JobSpecification.ExecutionResource(command.getId(), command.getResources()), (List)applicationResources, environmentVariables, jobRequest.getRequestedAgentConfig().isInteractive(), jobRequest.getRequestedAgentConfig().getRequestedJobDirectoryLocation().orElse(this.defaultJobDirectory), this.toArchiveLocation(jobRequest.getRequestedJobArchivalData().getRequestedArchiveLocationPrefix().orElse(this.defaultArchiveLocation), id), timeout);
        JobEnvironment jobEnvironment = new JobEnvironment.Builder(jobMemory).withEnvironmentVariables(environmentVariables).build();
        return new ResolvedJob(jobSpecification, jobEnvironment, jobRequest.getMetadata());
    }

    private Map<Cluster, String> queryForClustersAndCommands(List<Criterion> clusterCriteria, Criterion commandCriterion) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            Map<Cluster, String> clustersAndCommands = this.clusterPersistenceService.findClustersAndCommandsForCriteria(clusterCriteria, commandCriterion);
            MetricsUtils.addSuccessTags(tags);
            Map<Cluster, String> map = clustersAndCommands;
            return map;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(CLUSTER_COMMAND_QUERY_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster selectCluster(String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, Set<Cluster> clusters) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet timerTags = Sets.newHashSet();
        HashSet counterTags = Sets.newHashSet();
        try {
            if (clusters.isEmpty()) {
                this.noClusterFoundCounter.increment();
                throw new GeniePreconditionException("No cluster/command combination found for the given criteria. Unable to continue");
            }
            Cluster cluster = clusters.size() == 1 ? (Cluster)clusters.stream().findFirst().orElseThrow(() -> new GenieServerException("Couldn't get cluster when size was one")) : this.selectClusterSelector(counterTags, clusters, id, jobRequest);
            log.info("Selected cluster {} for job {}", (Object)cluster.getId(), (Object)id);
            MetricsUtils.addSuccessTags(timerTags);
            Cluster cluster2 = cluster;
            return cluster2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(timerTags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_CLUSTER_TIMER_NAME, (Iterable)timerTags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Command getCommand(String commandId, String jobId) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            log.info("Selecting command for job {} ", (Object)jobId);
            Command command = this.commandPersistenceService.getCommand(commandId);
            log.info("Selected command {} for job {} ", (Object)commandId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            Command command2 = command;
            return command2;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_COMMAND_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private List<Application> getApplications(String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, Command command) throws GenieJobResolutionException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            String commandId = command.getId();
            log.info("Selecting applications for job {} and command {}", (Object)id, (Object)commandId);
            ArrayList applications = Lists.newArrayList();
            if (jobRequest.getCriteria().getApplicationIds().isEmpty()) {
                applications.addAll(this.commandPersistenceService.getApplicationsForCommand(commandId));
            } else {
                for (String applicationId : jobRequest.getCriteria().getApplicationIds()) {
                    applications.add(this.applicationPersistenceService.getApplication(applicationId));
                }
            }
            log.info("Selected applications {} for job {}", (Object)applications.stream().map(rec$ -> ((Application)rec$).getId()).reduce((one, two) -> one + "," + two).orElse(NO_ID_FOUND), (Object)id);
            MetricsUtils.addSuccessTags(tags);
            ArrayList arrayList = applications;
            return arrayList;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw new GenieJobResolutionException(t);
        }
        finally {
            this.registry.timer(SELECT_APPLICATIONS_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private Cluster selectClusterSelector(Set<Tag> counterTags, Set<Cluster> clusters, String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest) throws GeniePreconditionException {
        Cluster cluster = null;
        for (ClusterSelector clusterSelector : this.clusterSelectorImpls) {
            Class targetClass;
            String clusterSelectorClass = clusterSelector instanceof TargetClassAware ? ((targetClass = ((TargetClassAware)clusterSelector).getTargetClass()) != null ? targetClass.getCanonicalName() : clusterSelector.getClass().getCanonicalName()) : clusterSelector.getClass().getCanonicalName();
            counterTags.add(Tag.of((String)"class", (String)clusterSelectorClass));
            try {
                Cluster selectedCluster = clusterSelector.selectCluster(clusters, this.toV3JobRequest(id, jobRequest));
                if (selectedCluster != null) {
                    if (clusters.contains(selectedCluster)) {
                        log.debug("Successfully selected cluster {} using selector {}", (Object)selectedCluster.getId(), (Object)clusterSelectorClass);
                        counterTags.addAll(Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"status", (String)CLUSTER_SELECTOR_STATUS_SUCCESS), Tag.of((String)"clusterId", (String)selectedCluster.getId()), Tag.of((String)"clusterName", (String)selectedCluster.getMetadata().getName()), Tag.of((String)"clusterSelectorClass", (String)clusterSelectorClass)}));
                        this.registry.counter(CLUSTER_SELECTOR_COUNTER_NAME, counterTags).increment();
                        cluster = selectedCluster;
                        break;
                    }
                    log.error("Successfully selected cluster {} using selector {} but it wasn't in original cluster list {}", new Object[]{selectedCluster.getId(), clusterSelectorClass, clusters});
                    counterTags.add(Tag.of((String)"status", (String)CLUSTER_SELECTOR_STATUS_INVALID));
                    this.registry.counter(CLUSTER_SELECTOR_COUNTER_NAME, counterTags).increment();
                    continue;
                }
                counterTags.add(Tag.of((String)"status", (String)CLUSTER_SELECTOR_STATUS_NO_PREFERENCE));
                this.registry.counter(CLUSTER_SELECTOR_COUNTER_NAME, counterTags).increment();
            }
            catch (Exception e) {
                log.error("Cluster selector {} threw exception:", (Object)clusterSelector, (Object)e);
                counterTags.add(Tag.of((String)"status", (String)CLUSTER_SELECTOR_STATUS_EXCEPTION));
                this.registry.counter(CLUSTER_SELECTOR_COUNTER_NAME, counterTags).increment();
            }
        }
        if (cluster == null) {
            this.noClusterSelectedCounter.increment();
            throw new GeniePreconditionException("Unable to select a cluster from using any of the available selectors.");
        }
        return cluster;
    }

    private ImmutableMap<String, String> generateEnvironmentVariables(String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, Cluster cluster, Command command, int memory) {
        ImmutableMap.Builder envVariables = ImmutableMap.builder();
        envVariables.put((Object)"GENIE_VERSION", (Object)"4");
        envVariables.put((Object)"GENIE_CLUSTER_ID", (Object)cluster.getId());
        envVariables.put((Object)"GENIE_CLUSTER_NAME", (Object)cluster.getMetadata().getName());
        envVariables.put((Object)"GENIE_CLUSTER_TAGS", (Object)this.tagsToString(cluster.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_COMMAND_ID", (Object)command.getId());
        envVariables.put((Object)"GENIE_COMMAND_NAME", (Object)command.getMetadata().getName());
        envVariables.put((Object)"GENIE_COMMAND_TAGS", (Object)this.tagsToString(command.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_ID", (Object)id);
        envVariables.put((Object)"GENIE_JOB_NAME", (Object)jobRequest.getMetadata().getName());
        envVariables.put((Object)"GENIE_JOB_MEMORY", (Object)String.valueOf(memory));
        envVariables.put((Object)"GENIE_JOB_TAGS", (Object)this.tagsToString(jobRequest.getMetadata().getTags()));
        envVariables.put((Object)"GENIE_JOB_GROUPING", (Object)jobRequest.getMetadata().getGrouping().orElse(""));
        envVariables.put((Object)"GENIE_JOB_GROUPING_INSTANCE", (Object)jobRequest.getMetadata().getGroupingInstance().orElse(""));
        envVariables.put((Object)"GENIE_REQUESTED_COMMAND_TAGS", (Object)this.tagsToString(jobRequest.getCriteria().getCommandCriterion().getTags()));
        List clusterCriteria = jobRequest.getCriteria().getClusterCriteria();
        ArrayList clusterCriteriaTags = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (int i = 0; i < clusterCriteria.size(); ++i) {
            Criterion criterion = (Criterion)clusterCriteria.get(i);
            String criteriaTagsString = this.tagsToString(criterion.getTags());
            envVariables.put((Object)("GENIE_REQUESTED_CLUSTER_TAGS_" + i), (Object)criteriaTagsString);
            clusterCriteriaTags.add("[" + criteriaTagsString + "]");
        }
        envVariables.put((Object)"GENIE_REQUESTED_CLUSTER_TAGS", (Object)("[" + StringUtils.join((Iterable)clusterCriteriaTags, (char)',') + "]"));
        envVariables.put((Object)"GENIE_USER", (Object)jobRequest.getMetadata().getUser());
        envVariables.put((Object)"GENIE_USER_GROUP", (Object)jobRequest.getMetadata().getGroup().orElse(""));
        return envVariables.build();
    }

    private JobRequest toV3JobRequest(String id, com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest) {
        JobRequest.Builder v3Builder = (JobRequest.Builder)((JobRequest.Builder)new JobRequest.Builder(jobRequest.getMetadata().getName(), jobRequest.getMetadata().getUser(), jobRequest.getMetadata().getVersion(), jobRequest.getCriteria().getClusterCriteria().stream().map(this::toClusterCriteria).collect(Collectors.toList()), this.toV3Tags(jobRequest.getCriteria().getCommandCriterion())).withId(id)).withApplications(jobRequest.getCriteria().getApplicationIds()).withCommandArgs(jobRequest.getCommandArgs()).withDisableLogArchival(jobRequest.getRequestedAgentConfig().isArchivingDisabled()).withTags(jobRequest.getMetadata().getTags());
        JobMetadata metadata = jobRequest.getMetadata();
        metadata.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withEmail(arg_0));
        metadata.getGroup().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroup(arg_0));
        metadata.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGrouping(arg_0));
        metadata.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroupingInstance(arg_0));
        metadata.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withDescription(arg_0));
        metadata.getMetadata().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withMetadata(arg_0));
        ExecutionEnvironment jobResources = jobRequest.getResources();
        v3Builder.withConfigs(jobResources.getConfigs());
        v3Builder.withDependencies(jobResources.getDependencies());
        jobResources.getSetupFile().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withSetupFile(arg_0));
        jobRequest.getRequestedAgentConfig().getTimeoutRequested().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withTimeout(arg_0));
        return v3Builder.build();
    }

    private ClusterCriteria toClusterCriteria(Criterion criterion) {
        return new ClusterCriteria(this.toV3Tags(criterion));
    }

    private Set<String> toV3Tags(Criterion criterion) {
        HashSet tags = Sets.newHashSet();
        criterion.getId().ifPresent(id -> tags.add("genie.id:" + id));
        criterion.getName().ifPresent(name -> tags.add("genie.name:" + name));
        tags.addAll(criterion.getTags());
        return tags;
    }

    private String tagsToString(Set<String> tags) {
        ArrayList sortedTags = Lists.newArrayList(tags);
        sortedTags.sort(Comparator.naturalOrder());
        String joinedString = StringUtils.join((Iterable)sortedTags, (char)',');
        return RegExUtils.replaceAll((String)RegExUtils.replaceAll((String)joinedString, (String)"'", (String)"\\'"), (String)"\"", (String)"\\\"");
    }

    private String toArchiveLocation(String requestedArchiveLocationPrefix, String jobId) {
        String archivePrefix;
        String string = archivePrefix = StringUtils.isBlank((CharSequence)requestedArchiveLocationPrefix) ? this.defaultArchiveLocation : requestedArchiveLocationPrefix;
        if (archivePrefix.endsWith(File.separator)) {
            return archivePrefix + jobId;
        }
        return archivePrefix + File.separator + jobId;
    }

    private int resolveJobMemory(com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest, Command command) {
        return jobRequest.getRequestedJobEnvironment().getRequestedJobMemory().orElse(command.getMemory().orElse(this.defaultMemory));
    }
}

