/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.services.MailService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

public class MailServiceImpl
implements MailService {
    private final JavaMailSender javaMailSender;
    private final String fromAddress;

    public MailServiceImpl(JavaMailSender javaMailSender, String fromAddress) {
        this.javaMailSender = javaMailSender;
        this.fromAddress = fromAddress;
    }

    @Override
    public void sendEmail(@NotBlank(message="Cannot send email to blank address.") @Nonnull @NotBlank(message="Cannot send email to blank address.") String toEmail, @NotBlank(message="Subject cannot be empty") @Nonnull @NotBlank(message="Subject cannot be empty") String subject, @Nullable String body) throws GenieException {
        SimpleMailMessage simpleMailMessage = new SimpleMailMessage();
        simpleMailMessage.setTo(toEmail);
        simpleMailMessage.setFrom(this.fromAddress);
        simpleMailMessage.setSubject(subject);
        if (StringUtils.isNotBlank((CharSequence)body)) {
            simpleMailMessage.setText(body);
        }
        try {
            this.javaMailSender.send(simpleMailMessage);
        }
        catch (MailException me) {
            throw new GenieServerException("Failure to send email", (Throwable)me);
        }
    }
}

