/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.launchers;

import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.agent.launchers.impl.LocalAgentLauncherImpl;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.introspection.GenieWebHostInfo;
import com.netflix.genie.web.introspection.GenieWebRpcInfo;
import com.netflix.genie.web.properties.LocalAgentLauncherProperties;
import com.netflix.genie.web.util.ExecutorFactory;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LocalAgentLauncherProperties.class})
public class AgentLaunchersAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ExecutorFactory.class})
    public ExecutorFactory processExecutorFactory() {
        return new ExecutorFactory();
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentLauncher.class})
    public LocalAgentLauncherImpl localAgentLauncher(GenieWebHostInfo genieWebHostInfo, GenieWebRpcInfo genieWebRpcInfo, JobSearchService jobSearchService, LocalAgentLauncherProperties launcherProperties, ExecutorFactory executorFactory, MeterRegistry registry) {
        return new LocalAgentLauncherImpl(genieWebHostInfo, genieWebRpcInfo, jobSearchService, launcherProperties, executorFactory, registry);
    }
}

