/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.tasks.leader;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.data.services.AgentConnectionPersistenceService;
import com.netflix.genie.web.data.services.ClusterPersistenceService;
import com.netflix.genie.web.data.services.FilePersistenceService;
import com.netflix.genie.web.data.services.JobPersistenceService;
import com.netflix.genie.web.data.services.JobSearchService;
import com.netflix.genie.web.data.services.TagPersistenceService;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.properties.AgentCleanupProperties;
import com.netflix.genie.web.properties.ClusterCheckerProperties;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.properties.LeadershipProperties;
import com.netflix.genie.web.properties.UserMetricsProperties;
import com.netflix.genie.web.properties.ZookeeperLeadershipProperties;
import com.netflix.genie.web.spring.autoconfigure.tasks.TasksAutoConfiguration;
import com.netflix.genie.web.tasks.leader.AgentJobCleanupTask;
import com.netflix.genie.web.tasks.leader.ClusterCheckerTask;
import com.netflix.genie.web.tasks.leader.DatabaseCleanupTask;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.genie.web.tasks.leader.LeadershipTasksCoordinator;
import com.netflix.genie.web.tasks.leader.LocalLeader;
import com.netflix.genie.web.tasks.leader.UserMetricsTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.zookeeper.config.LeaderInitiatorFactoryBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={AgentCleanupProperties.class, ClusterCheckerProperties.class, DatabaseCleanupProperties.class, LeadershipProperties.class, UserMetricsProperties.class, ZookeeperLeadershipProperties.class})
@AutoConfigureAfter(value={TasksAutoConfiguration.class, ZookeeperAutoConfiguration.class})
public class LeaderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LeadershipTasksCoordinator.class})
    public LeadershipTasksCoordinator leadershipTasksCoordinator(@Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, Set<LeadershipTask> tasks) {
        return new LeadershipTasksCoordinator(taskScheduler, tasks);
    }

    @Bean
    @ConditionalOnBean(value={CuratorFramework.class})
    @ConditionalOnMissingBean(value={LeaderInitiatorFactoryBean.class})
    public LeaderInitiatorFactoryBean leaderInitiatorFactory(CuratorFramework client, ZookeeperLeadershipProperties zookeeperLeadershipProperties) {
        LeaderInitiatorFactoryBean factoryBean = new LeaderInitiatorFactoryBean();
        factoryBean.setClient(client);
        factoryBean.setPath(zookeeperLeadershipProperties.getPath());
        factoryBean.setRole("cluster");
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={CuratorFramework.class, LocalLeader.class})
    public LocalLeader localLeader(GenieEventBus genieEventBus, LeadershipProperties leadershipProperties) {
        return new LocalLeader(genieEventBus, leadershipProperties.isEnabled());
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterCheckerTask.class})
    public ClusterCheckerTask clusterCheckerTask(GenieHostInfo genieHostInfo, ClusterCheckerProperties properties, JobSearchService jobSearchService, JobPersistenceService jobPersistenceService, AgentConnectionPersistenceService agentConnectionPersistenceService, @Qualifier(value="genieRestTemplate") RestTemplate restTemplate, WebEndpointProperties webEndpointProperties, MeterRegistry registry) {
        return new ClusterCheckerTask(genieHostInfo, properties, jobSearchService, jobPersistenceService, agentConnectionPersistenceService, restTemplate, webEndpointProperties, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.database-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DatabaseCleanupTask.class})
    public DatabaseCleanupTask databaseCleanupTask(DatabaseCleanupProperties cleanupProperties, JobPersistenceService jobPersistenceService, ClusterPersistenceService clusterPersistenceService, FilePersistenceService filePersistenceService, TagPersistenceService tagPersistenceService, MeterRegistry registry) {
        return new DatabaseCleanupTask(cleanupProperties, jobPersistenceService, clusterPersistenceService, filePersistenceService, tagPersistenceService, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.user-metrics.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={UserMetricsTask.class})
    public UserMetricsTask userMetricsTask(MeterRegistry registry, JobSearchService jobSearchService, UserMetricsProperties userMetricsProperties) {
        return new UserMetricsTask(registry, jobSearchService, userMetricsProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.agent-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={AgentJobCleanupTask.class})
    public AgentJobCleanupTask agentJobCleanupTask(JobSearchService jobSearchService, JobPersistenceService jobPersistenceService, AgentCleanupProperties agentCleanupProperties, MeterRegistry registry) {
        return new AgentJobCleanupTask(jobSearchService, jobPersistenceService, agentCleanupProperties, registry);
    }
}

