/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class StreamBuffer {
    private static final Logger log = LoggerFactory.getLogger(StreamBuffer.class);
    private final Object lock = new Object();
    private final AtomicReference<StreamBufferInputStream> inputStreamRef = new AtomicReference();
    private boolean closed;
    private ByteString currentChunk;
    private int currentChunkWatermark;

    public StreamBuffer() {
        this.inputStreamRef.set(new StreamBufferInputStream(this));
    }

    public void closeForError(Throwable t) {
        log.error("Closing buffer due to error: " + t.getClass().getSimpleName() + ": " + t.getMessage());
        this.closeForCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForCompleted() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    public void write(ByteString data) {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.closed) {
                    throw new IllegalStateException("Attempting to write after closing");
                }
                if (this.currentChunk == null) {
                    this.currentChunk = data;
                    this.currentChunkWatermark = 0;
                    this.lock.notifyAll();
                    return;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting to write next chunk of data");
                }
            }
        }
    }

    public InputStream getInputStream() {
        InputStream inputStream = this.inputStreamRef.getAndSet(null);
        if (inputStream == null) {
            throw new IllegalStateException("Input stream for this buffer is no longer available");
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read(byte[] destination) {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.currentChunk != null) {
                    int leftInCurrentChunk = this.currentChunk.size() - this.currentChunkWatermark;
                    int bytesRead = Math.min(leftInCurrentChunk, destination.length);
                    this.currentChunk.copyTo(destination, this.currentChunkWatermark, 0, bytesRead);
                    this.currentChunkWatermark += bytesRead;
                    if (this.currentChunkWatermark == this.currentChunk.size()) {
                        this.currentChunk = null;
                        this.lock.notifyAll();
                    }
                    return bytesRead;
                }
                if (this.closed) {
                    return -1;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while attempting read");
                    return 0;
                }
            }
        }
    }

    private static class StreamBufferInputStream
    extends InputStream {
        private final StreamBuffer streamBuffer;

        StreamBufferInputStream(StreamBuffer streamBuffer) {
            this.streamBuffer = streamBuffer;
        }

        @Override
        public int read() {
            throw new NotImplementedException("Not implemented");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("Invalid read( b[" + b.length + "], " + off + ", " + len + ")");
            }
            byte[] temporary = new byte[len];
            int bytesRead = this.streamBuffer.read(temporary);
            if (bytesRead > 0) {
                System.arraycopy(temporary, 0, b, off, bytesRead);
            }
            return bytesRead;
        }
    }
}

